<?php

// Register blocks
add_action( 'init', 'lsvr_services_register_blocks', 20 );
if ( ! function_exists( 'lsvr_services_register_blocks' ) ) {
	function lsvr_services_register_blocks() {

		if ( function_exists( 'register_block_type' ) && function_exists( 'lsvr_framework_register_shortcode_block' ) ) {

    		// Service List Widget
			if ( class_exists( 'Lsvr_Shortcode_Service_List_Widget' ) ) {
				lsvr_framework_register_shortcode_block( 'lsvr-services/service-list-widget', array(
					'attributes' => Lsvr_Shortcode_Service_List_Widget::lsvr_shortcode_atts(),
					'render_callback' => array( 'Lsvr_Shortcode_Service_List_Widget', 'shortcode' ),
				));
			}

    		// Featured Service Widget
			if ( class_exists( 'Lsvr_Shortcode_Service_Featured_Widget' ) ) {
				lsvr_framework_register_shortcode_block( 'lsvr-services/service-featured-widget', array(
					'attributes' => Lsvr_Shortcode_Service_Featured_Widget::lsvr_shortcode_atts(),
					'render_callback' => array( 'Lsvr_Shortcode_Service_Featured_Widget', 'shortcode' ),
				));
			}

		}

	}
}

// Register blocks JSON
add_filter( 'lsvr_framework_register_shortcode_blocks_json', 'lsvr_services_register_blocks_json' );
if ( ! function_exists( 'lsvr_services_register_blocks_json' ) ) {
	function lsvr_services_register_blocks_json( $data = array() ) {

		$data = empty( $data ) ? array() : $data;

		if ( function_exists( 'register_block_type' ) && function_exists( 'lsvr_framework_register_shortcode_block_json' ) ) {

			// Service List Widget
			if ( class_exists( 'Lsvr_Shortcode_Service_List_Widget' ) ) {
				array_push( $data, lsvr_framework_register_shortcode_block_json( array(
					'name' => 'lsvr-services/service-list-widget',
					'tag' => 'lsvr_service_list_widget',
					'title' => esc_html__( 'LSVR Services Widget', 'lsvr-services' ),
		        	'description' => esc_html__( 'List of service posts', 'lsvr-services' ),
		        	'category' => 'lsvr-widgets',
		        	'icon' => 'businessman',
		        	'panel_title' => esc_html__( 'Settings', 'lsvr-services' ),
		        	'attributes' => Lsvr_Shortcode_Service_List_Widget::lsvr_shortcode_atts(),
				)));
			}

			// Service Featured Widget
			if ( class_exists( 'Lsvr_Shortcode_Service_Featured_Widget' ) ) {
				array_push( $data, lsvr_framework_register_shortcode_block_json( array(
					'name' => 'lsvr-services/service-featured-widget',
					'tag' => 'lsvr_service_featured_widget',
					'title' => esc_html__( 'LSVR Featured Service Widget', 'lsvr-services' ),
		        	'description' => esc_html__( 'Single service post', 'lsvr-services' ),
		        	'category' => 'lsvr-widgets',
		        	'icon' => 'businessman',
		        	'panel_title' => esc_html__( 'Settings', 'lsvr-services' ),
		        	'attributes' => Lsvr_Shortcode_Service_Featured_Widget::lsvr_shortcode_atts(),
				)));
			}

		}

		return $data;

	}
}

?>