<?php
/**
 * Service post type
 */
if ( ! class_exists( 'Lsvr_CPT_Service' ) && class_exists( 'Lsvr_CPT' ) ) {
    class Lsvr_CPT_Service extends Lsvr_CPT {

		public function __construct() {

			parent::__construct( array(
				'id' => 'lsvr_service',
				'wp_args' => array(
					'labels' => array(
						'name' => esc_html__( 'Services', 'lsvr-services' ),
						'singular_name' => esc_html__( 'Service', 'lsvr-services' ),
						'add_new' => esc_html__( 'Add New Service', 'lsvr-services' ),
						'add_new_item' => esc_html__( 'Add New Service', 'lsvr-services' ),
						'edit_item' => esc_html__( 'Edit Service', 'lsvr-services' ),
						'new_item' => esc_html__( 'Add New Service', 'lsvr-services' ),
						'view_item' => esc_html__( 'View Service', 'lsvr-services' ),
						'search_items' => esc_html__( 'Search services', 'lsvr-services' ),
						'not_found' => esc_html__( 'No services found', 'lsvr-services' ),
						'not_found_in_trash' => esc_html__( 'No services found in trash', 'lsvr-services' ),
					),
					'exclude_from_search' => false,
					'public' => true,
					'supports' => array( 'title', 'editor', 'custom-fields', 'revisions', 'excerpt', 'thumbnail', 'author' ),
					'capability_type' => 'post',
					'rewrite' => array( 'slug' => 'services' ),
					'menu_position' => 5,
					'has_archive' => true,
					'show_in_nav_menus' => true,
					'show_in_rest' => true,
					'menu_icon' => 'dashicons-businessman',
				),
			));

			// Add Category taxonomy
			$this->add_taxonomy(array(
				'id' => 'lsvr_service_cat',
				'wp_args' => array(
					'labels' => array(
						'name' => esc_html__( 'Service Categories', 'lsvr-services' ),
						'singular_name' => esc_html__( 'Service Category', 'lsvr-services' ),
						'search_items' => esc_html__( 'Search Service Categories', 'lsvr-services' ),
						'popular_items' => esc_html__( 'Popular Service Categories', 'lsvr-services' ),
						'all_items' => esc_html__( 'All Service Categories', 'lsvr-services' ),
						'parent_item' => esc_html__( 'Parent Service Category', 'lsvr-services' ),
						'parent_item_colon' => esc_html__( 'Parent Service Category:', 'lsvr-services' ),
						'edit_item' => esc_html__( 'Edit Service Category', 'lsvr-services' ),
						'update_item' => esc_html__( 'Update Service Category', 'lsvr-services' ),
						'add_new_item' => esc_html__( 'Add New Service Category', 'lsvr-services' ),
						'new_item_name' => esc_html__( 'New Service Category Name', 'lsvr-services' ),
						'separate_items_with_commas' => esc_html__( 'Separate service categories by comma', 'lsvr-services' ),
						'add_or_remove_items' => esc_html__( 'Add or remove service categories', 'lsvr-services' ),
						'choose_from_most_used' => esc_html__( 'Choose from the most used service categories', 'lsvr-services' ),
						'menu_name' => esc_html__( 'Service Categories', 'lsvr-services' )
					),
					'public' => true,
					'show_in_nav_menus' => true,
					'show_ui' => true,
					'show_admin_column' => true,
					'show_tagcloud' => true,
					'hierarchical' => true,
					'rewrite' => array( 'slug' => 'service-category' ),
					'query_var' => true,
					'show_in_rest' => true,
				),
				'args' => array(
					'admin_tax_filter' => true,
				),
			));

			// Add Tag taxonomy
			$this->add_taxonomy(array(
				'id' => 'lsvr_service_tag',
				'wp_args' => array(
					'labels' => array(
						'name' => esc_html__( 'Service Tags', 'lsvr-services' ),
						'singular_name' => esc_html__( 'Service Tag', 'lsvr-services' ),
						'search_items' => esc_html__( 'Search Service Tags', 'lsvr-services' ),
						'popular_items' => esc_html__( 'Popular Service Tags', 'lsvr-services' ),
						'all_items' => esc_html__( 'All Service Tags', 'lsvr-services' ),
						'parent_item' => esc_html__( 'Parent Service Tag', 'lsvr-services' ),
						'parent_item_colon' => esc_html__( 'Parent Service Tag:', 'lsvr-services' ),
						'edit_item' => esc_html__( 'Edit Service Tag', 'lsvr-services' ),
						'update_item' => esc_html__( 'Update Service Tag', 'lsvr-services' ),
						'add_new_item' => esc_html__( 'Add New Service Tag', 'lsvr-services' ),
						'new_item_name' => esc_html__( 'New Service Tag Name', 'lsvr-services' ),
						'separate_items_with_commas' => esc_html__( 'Separate service tags by comma', 'lsvr-services' ),
						'add_or_remove_items' => esc_html__( 'Add or remove service tags', 'lsvr-services' ),
						'choose_from_most_used' => esc_html__( 'Choose from the most used service tags', 'lsvr-services' ),
						'menu_name' => esc_html__( 'Service Tags', 'lsvr-services' )
					),
					'public' => true,
					'show_in_nav_menus' => true,
					'show_ui' => true,
					'show_admin_column' => true,
					'show_tagcloud' => true,
					'hierarchical' => false,
					'rewrite' => array( 'slug' => 'service-tag' ),
					'query_var' => true,
					'show_in_rest' => true,
				),
				'args' => array(
					'admin_tax_filter' => true,
				),
			));

			// Additional custom admin functionality
			if ( is_admin() ) {

				// Add metaboxes
				add_action( 'init', array( $this, 'add_service_post_metabox' ) );

			}

		}

		// Add Service Settings metabox
		public function add_service_post_metabox() {
			if ( class_exists( 'Lsvr_Post_Metabox' ) ) {

				// Service settings metabox
				$lsvr_service_settings_metabox = new Lsvr_Post_Metabox(array(
					'id' => 'lsvr_service_settings',
					'wp_args' => array(
						'title' => __( 'Service Settings', 'lsvr-services' ),
						'screen' => 'lsvr_service',
						'context' => 'normal',
						'priority' => 'high',
					),
					'fields' => array(

						// Icon class
						'lsvr_service_icon_class' => array(
							'type' => 'text',
							'title' => esc_html__( 'Service Icon Class', 'lsvr-services' ),
							'description' => esc_html__( 'Insert icon class name. For example "icon-cog". Please refer to the documentation to learn more about icons.', 'lsvr-services' ),
							'priority' => 10,
						),

					),
				));

				// Service gallery metabox
				$lsvr_service_gallery_metabox = new Lsvr_Post_Metabox(array(
					'id' => 'lsvr_service_images',
					'wp_args' => array(
						'title' => __( 'Service Gallery', 'lsvr-services' ),
						'screen' => 'lsvr_service',
					),
					'fields' => array(

						// Gallery
						'lsvr_service_images' => array(
							'type' => 'gallery',
							'description' => esc_html__( 'Upload new or select existing images.', 'lsvr-services' ),
							'multiple' => true,
							'select_btn_label' => esc_html__( 'Manage Gallery Images', 'lsvr-services' ),
							'media_type' => array( 'image' ),
							'priority' => 10,
						),

					),
				));

			}
		}

	}
}

?>