<?php
/**
 * LSVR Service List Widget Shortcode
 */
if ( ! class_exists( 'Lsvr_Shortcode_Service_List_Widget' ) ) {
    class Lsvr_Shortcode_Service_List_Widget {

        public static function shortcode( $atts = array(), $content = null, $tag = '' ) {

            // Merge default atts and received atts
            $args = shortcode_atts(
                array(
                    'title' => '',
                    'category' => 0,
                    'limit' => 0,
                    'order' => 'default',
                    'more_label' => '',
                    'id' => '',
                    'className' => '',
                    'editor_view' => false,
                ),
                $atts
            );

            // Check if editor view
            $editor_view = true === $args['editor_view'] || '1' === $args['editor_view'] || 'true' === $args['editor_view'] ? true : false;

            // Element class
            $class_arr = array( 'widget shortcode-widget lsvr_service-list-widget lsvr_service-list-widget--shortcode' );
            if ( true === $editor_view ) {
                array_push( $class_arr, 'lsvr_service-list-widget--editor-view' );
            }
            if ( ! empty( $args['className'] ) ) {
                array_push( $class_arr, $args['className'] );
            }

            ob_start(); ?>

            <?php the_widget( 'Lsvr_Widget_Service_List', array(
                'title' => $args['title'],
                'category' => $args['category'],
                'limit' => $args['limit'],
                'order' => $args['order'],
                'more_label' => $args['more_label'],
                'editor_view' => $args['editor_view'],
            ), array(
                'before_widget' => '<div' . ( ! empty( $args['id'] ) ? ' id="' . esc_attr( $args['id'] ) . '"' : '' ) . ' class="' . esc_attr( implode( ' ', $class_arr ) ) . '"><div class="widget__inner">',
                'after_widget' => '</div></div>',
                'before_title' => '<h3 class="widget__title">',
                'after_title' => '</h3>',
            )); ?>

            <?php return ob_get_clean();

        }

        // Shortcode params
        public static function lsvr_shortcode_atts() {
            return array_merge( array(

                // Title
                array(
                    'name' => 'title',
                    'type' => 'text',
                    'label' => esc_html__( 'Title', 'lsvr-services' ),
                    'description' => esc_html__( 'Title of this section.', 'lsvr-services' ),
                    'default' => esc_html__( 'Services', 'lsvr-services' ),
                    'priority' => 10,
                ),

                // Category
                array(
                    'name' => 'category',
                    'type' => 'taxonomy',
                    'tax' => 'lsvr_service_cat',
                    'label' => esc_html__( 'Category', 'lsvr-services' ),
                    'description' => esc_html__( 'Display services from a specific category.', 'lsvr-services' ),
                    'priority' => 20,
                ),

                // Limit
                array(
                    'name' => 'limit',
                    'type' => 'select',
                    'label' => esc_html__( 'Limit', 'lsvr-services' ),
                    'description' => esc_html__( 'How many services to display.', 'lsvr-services' ),
                    'choices' => array( 0 => esc_html__( 'All', 'lsvr-services' ) ) + range( 0, 20, 1 ),
                    'default' => 0,
                    'priority' => 30,
                ),

                // Order
                array(
                    'name' => 'order',
                    'type' => 'select',
                    'label' => esc_html__( 'Order', 'lsvr-services' ),
                    'description' => esc_html__( 'Order of Service posts.', 'lsvr-services' ),
                    'choices' => array(
                        'default' => esc_html__( 'Default', 'lsvr-services' ),
                        'date_desc' => esc_html__( 'By date, newest first', 'lsvr-services' ),
                        'date_asc' => esc_html__( 'By date, oldest first', 'lsvr-services' ),
                        'title_asc' => esc_html__( 'By title, ascending', 'lsvr-services' ),
                        'title_desc' => esc_html__( 'By title, descending', 'lsvr-services' ),
                        'random' => esc_html__( 'Random', 'lsvr-services' ),
                    ),
                    'default' => 'default',
                    'priority' => 40,
                ),

                // More label
                array(
                    'name' => 'more_label',
                    'type' => 'text',
                    'label' => esc_html__( 'More Link Label', 'lsvr-services' ),
                    'description' => esc_html__( 'Link to services archive. Leave blank to hide.', 'lsvr-services' ),
                    'default' => esc_html__( 'More Services', 'lsvr-services' ),
                    'priority' => 60,
                ),

                // ID
                array(
                    'name' => 'id',
                    'type' => 'text',
                    'label' => esc_html__( 'Unique ID', 'lsvr-services' ),
                    'description' => esc_html__( 'You can use this ID to style this specific element with custom CSS, for example.', 'lsvr-services' ),
                    'priority' => 70,
                ),

            ), apply_filters( 'lsvr_service_list_widget_shortcode_atts', array() ) );
        }

    }
}
?>