<?php
/**
 * LSVR Service Categories widget
 *
 * Display list of lsvr_service_cat tax terms
 */
if ( ! class_exists( 'Lsvr_Widget_Service_Categories' ) && class_exists( 'Lsvr_Widget' ) ) {
class Lsvr_Widget_Service_Categories extends Lsvr_Widget {

    public function __construct() {

    	// Init widget
		parent::__construct(array(
			'id' => 'lsvr_services_service_categories',
			'classname' => 'lsvr_service-categories-widget',
			'title' => esc_html__( 'LSVR Service Categories', 'lsvr-services' ),
			'description' => esc_html__( 'List of Service categories', 'lsvr-services' ),
			'fields' => array(
				'title' => array(
					'label' => esc_html__( 'Title:', 'lsvr-services' ),
					'type' => 'text',
					'default' => esc_html__( 'Service Categories', 'lsvr-services' ),
				),
			),
		));

    }

    function widget( $args, $instance ) {
        ?>

        <?php // Before widget content
        parent::before_widget_content( $args, $instance ); ?>

        <div class="widget__content">

			<ul class="root">
	        	<?php wp_list_categories(array(
					'title_li' => '',
					'taxonomy' => 'lsvr_service_cat',
					'show_count' => false,
				)); ?>
			</ul>

        </div>

        <?php // After widget content
        parent::after_widget_content( $args, $instance ); ?>

        <?php

    }

}}

?>