<?php
/**
 * LSVR Featured Service widget
 *
 * Single lsvr_service post
 */
if ( ! class_exists( 'Lsvr_Widget_Service_Featured' ) && class_exists( 'Lsvr_Widget' ) ) {
class Lsvr_Widget_Service_Featured extends Lsvr_Widget {

    public function __construct() {

    	// Init widget
		parent::__construct(array(
			'id' => 'lsvr_services_service_featured',
			'classname' => 'lsvr_service-featured-widget',
			'title' => esc_html__( 'LSVR Featured Service', 'lsvr-services' ),
			'description' => esc_html__( 'Single Service post', 'lsvr-services' ),
			'fields' => array(
				'title' => array(
					'label' => esc_html__( 'Title:', 'lsvr-services' ),
					'type' => 'text',
					'default' => esc_html__( 'Featured Service', 'lsvr-services' ),
				),
				'post' => array(
					'label' => esc_html__( 'Service:', 'lsvr-services' ),
					'description' => esc_html__( 'Choose service to display.', 'lsvr-services' ),
					'type' => 'post',
					'post_type' => 'lsvr_service',
					'default_label' => esc_html__( 'Random', 'lsvr-services' ),
				),
				'show_category' => array(
					'label' => esc_html__( 'Display Category', 'lsvr-services' ),
					'type' => 'checkbox',
					'default' => 'true',
				),
				'show_excerpt' => array(
					'label' => esc_html__( 'Display Excerpt', 'lsvr-services' ),
					'type' => 'checkbox',
					'default' => 'true',
				),
				'more_label' => array(
					'label' => esc_html__( 'More Button Label:', 'lsvr-services' ),
					'description' => esc_html__( 'Link to service post archive. Leave blank to hide.', 'lsvr-services' ),
					'type' => 'text',
					'default' => esc_html__( 'More Services', 'lsvr-services' ),
				),
			),
		));

    }

    function widget( $args, $instance ) {

    	// Show category
    	$show_category = ! empty( $instance['show_category'] ) && ( true === $instance['show_category'] || 'true' === $instance['show_category'] || '1' === $instance['show_category'] ) ? true : false;

    	// Show excerpt
    	$show_excerpt = ! empty( $instance['show_excerpt'] ) && ( true === $instance['show_excerpt'] || 'true' === $instance['show_excerpt'] || '1' === $instance['show_excerpt'] ) ? true : false;

    	// Get random post
    	if ( empty( $instance['post'] ) || ( ! empty( $instance['post'] ) && 'none' === $instance['post'] ) ) {
    		$service_post = get_posts( array(
    			'post_type' => 'lsvr_service',
    			'orderby' => 'rand',
    			'posts_per_page' => '1'
			));
			$service_post = ! empty( $service_post[0] ) ? $service_post[0] : '';
    	}

    	// Get post
    	else if ( ! empty( $instance['post'] ) ) {
    		$service_post = get_post( $instance['post'] );
    	}

    	// Get additional data
    	if ( ! empty( $service_post ) ) {
    		$service_meta = lsvr_services_get_service_meta( $service_post->ID );
    		$service_thumb = lsvr_services_get_service_thumb( $service_post->ID );
    	}

        ?>

        <?php // Before widget content
        parent::before_widget_content( $args, $instance ); ?>

        <div class="widget__content lsvr_service-featured-widget__content<?php if ( ! empty( $service_thumb ) ) { echo ' lsvr_service-featured-widget__content--has-thumb'; } ?>">

        	<?php if ( ! empty( $service_post ) ) : ?>

    			<?php // Thumbnail
    			if ( ! empty( $service_thumb ) ) : ?>

    				<p class="lsvr_service-featured-widget__thumb">
    					<a href="<?php echo esc_url( get_permalink( $service_post->ID ) ); ?>" class="lsvr_service-featured-widget__thumb-link">
    						<img src="<?php echo esc_url( $service_thumb['medium_url'] ); ?>"
    							title="<?php echo esc_attr( $service_thumb['title'] ); ?>"
    							alt="<?php echo esc_attr( $service_thumb['alt'] ); ?>">
    					</a>
    				</p>

    			<?php endif; ?>

    			<div class="lsvr_service-featured-widget__content-inner">

					<?php if ( ! empty( $service_meta['icon_class'] ) ) : ?>
						<p class="lsvr_service-featured-widget__icon">
							<i class="lsvr_service-featured-widget__icon-image <?php echo esc_attr( $service_meta['icon_class'] ); ?>"></i>
						</p>
					<?php endif; ?>

	    			<h4 class="lsvr_service-featured-widget__title">
	    				<a href="<?php echo esc_url( get_permalink( $service_post->ID ) ); ?>" class="lsvr_service-featured-widget__title-link">
	    					<?php echo get_the_title( $service_post->ID ); ?>
	    				</a>
	    			</h4>

					<?php // Category
					$terms = wp_get_post_terms( $service_post->ID, 'lsvr_service_cat' );
					$category_html = '';
					if ( ! empty( $terms ) ) {
						foreach ( $terms as $term ) {
							$category_html .= '<a href="' . esc_url( get_term_link( $term->term_id, 'lsvr_service_cat' ) ) . '" class="lsvr_service-featured-widget__category-link">' . $term->name . '</a>';
							$category_html .= $term !== end( $terms ) ? ', ' : '';
						}
					}
					if ( true === $show_category && ! empty( $category_html ) ) : ?>
						<p class="lsvr_service-featured-widget__category">
							<?php echo sprintf( esc_html__( 'in %s', 'lsvr-services' ), $category_html ); ?>
						</p>
					<?php endif; ?>

					<?php // Excerpt
					if ( true === $show_excerpt && has_excerpt( $service_post->ID ) ) : ?>
						<div class="lsvr_service-featured-widget__excerpt">
							<?php echo wpautop( get_the_excerpt( $service_post->ID ) ); ?>
						</div>
					<?php endif; ?>

					<?php if ( ! empty( $instance[ 'more_label' ] ) ) : ?>
					<p class="widget__more">
						<a href="<?php echo esc_url( get_post_type_archive_link( 'lsvr_service' ) ); ?>" class="widget__more-link"><?php echo esc_html( $instance[ 'more_label' ] ); ?></a>
					</p>
					<?php endif; ?>

				</div>

        	<?php else : ?>
        		<p class="widget__no-results"><?php esc_html_e( 'There are no services', 'lsvr-services' ); ?></p>
        	<?php endif; ?>

        </div>

        <?php // After widget content
        parent::after_widget_content( $args, $instance ); ?>

        <?php

    }

}}

?>