<?php
/**
 * LSVR Services widget
 *
 * Display list of lsvr_service posts
 */
if ( ! class_exists( 'Lsvr_Widget_Service_List' ) && class_exists( 'Lsvr_Widget' ) ) {
class Lsvr_Widget_Service_List extends Lsvr_Widget {

    public function __construct() {

    	// Init widget
		parent::__construct(array(
			'id' => 'lsvr_services_service_list',
			'classname' => 'lsvr_service-list-widget',
			'title' => esc_html__( 'LSVR Services', 'lsvr-services' ),
			'description' => esc_html__( 'List of Service posts', 'lsvr-services' ),
			'fields' => array(
				'title' => array(
					'label' => esc_html__( 'Title:', 'lsvr-services' ),
					'type' => 'text',
					'default' => esc_html__( 'Services', 'lsvr-services' ),
				),
				'category' => array(
					'label' => esc_html__( 'Category:', 'lsvr-services' ),
					'description' => esc_html__( 'Display services only from a certain category.', 'lsvr-services' ),
					'type' => 'taxonomy',
					'taxonomy' => 'lsvr_service_cat',
					'default_label' => esc_html__( 'None', 'lsvr-services' ),
				),
				'limit' => array(
					'label' => esc_html__( 'Limit:', 'lsvr-services' ),
					'description' => esc_html__( 'Number of services to display.', 'lsvr-services' ),
					'type' => 'select',
					'choices' => array( 0 => esc_html__( 'All', 'lsvr-services' ), 1, 2, 3, 4, 5, 6, 7, 8, 9, 10 ),
					'default' => 0,
				),
				'order' => array(
					'label' => esc_html__( 'Order:', 'lsvr-services' ),
					'description' => esc_html__( 'Order of Service posts.', 'lsvr-services' ),
					'type' => 'select',
					'choices' => array(
						'default' => esc_html__( 'Default', 'lsvr-services' ),
                        'date_desc' => esc_html__( 'By date, newest first', 'lsvr-services' ),
                        'date_asc' => esc_html__( 'By date, oldest first', 'lsvr-services' ),
                        'title_asc' => esc_html__( 'By title, ascending', 'lsvr-services' ),
                        'title_desc' => esc_html__( 'By title, descending', 'lsvr-services' ),
                        'random' => esc_html__( 'Random', 'lsvr-services' ),
					),
					'default' => 'default',
				),
				'more_label' => array(
					'label' => esc_html__( 'More Button Label:', 'lsvr-services' ),
					'description' => esc_html__( 'Link to service post archive. Leave blank to hide.', 'lsvr-services' ),
					'type' => 'text',
					'default' => esc_html__( 'More Services', 'lsvr-services' ),
				),
			),
		));

    }

    function widget( $args, $instance ) {

    	// Get service posts
    	$query_args = array(
    		'limit' => array_key_exists( 'limit', $instance ) ? $instance[ 'limit' ] : 0,
		);
		if ( ! empty( $instance['category'] ) && 'none' !== $instance['category'] ) {
			$query_args['category'] = $instance['category'];
		}
		if ( ! empty( $instance['order'] ) && 'default' !== $instance['order'] ) {
			if ( 'date_desc' == $instance['order'] ) {
				$query_args['orderby'] = 'date';
				$query_args['order'] = 'DESC';
			}
			elseif ( 'date_asc' == $instance['order'] ) {
				$query_args['orderby'] = 'date';
				$query_args['order'] = 'ASC';
			}
			elseif ( 'title_asc' == $instance['order'] ) {
				$query_args['orderby'] = 'title';
				$query_args['order'] = 'ASC';
			}
			elseif ( 'title_desc' == $instance['order'] ) {
				$query_args['orderby'] = 'title';
				$query_args['order'] = 'DESC';
			}
			elseif ( 'random' == $instance['order'] ) {
				$query_args['orderby'] = 'rand';
			}
		}
    	$posts = lsvr_services_get( $query_args );

        ?>

        <?php // Before widget content
        parent::before_widget_content( $args, $instance ); ?>

        <div class="widget__content">

        	<?php if ( ! empty( $posts ) ) : ?>

        		<ul class="lsvr_service-list-widget__list">
	        		<?php foreach ( $posts as $service_id => $service_post ) : ?>

						<?php $service_post = $service_post['post'];
						$service_meta = lsvr_services_get_service_meta( $service_post->ID );
						$item_class_arr = array();
						if ( ! empty( $service_meta['icon_class'] ) ) {
							array_push( $item_class_arr, 'lsvr_service-list-widget__item--has-icon' );
						}
						if ( is_singular( 'lsvr_service' ) && $service_post->ID === get_the_ID() ) {
							array_push( $item_class_arr, 'lsvr_service-list-widget__item--current' );
						} ?>

	        			<li class="lsvr_service-list-widget__item <?php echo esc_attr( implode( $item_class_arr, ' ' ) ); ?>">

	        				<?php if ( ! empty( $service_meta['icon_class'] ) ) : ?>

	        					<i class="lsvr_service-list-widget__item-icon <?php echo esc_attr( $service_meta['icon_class'] ); ?>"></i>

	        				<?php endif; ?>

							<a href="<?php echo esc_url( get_permalink( $service_id ) ); ?>" class="lsvr_service-list-widget__item-link">
								<?php echo esc_html( $service_post->post_title ); ?>
							</a>

	        			</li>

	        		<?php endforeach; ?>
        		</ul>

				<?php if ( ! empty( $instance[ 'more_label' ] ) ) : ?>

					<p class="widget__more">

						<?php if ( ! empty( $instance['category'] ) && is_numeric( $instance['category'] ) ) : ?>

							<a href="<?php echo esc_url( get_term_link( (int) $instance['category'], 'lsvr_service_cat' ) ); ?>" class="widget__more-link"><?php echo esc_html( $instance[ 'more_label' ] ); ?></a>

						<?php else : ?>

							<a href="<?php echo esc_url( get_post_type_archive_link( 'lsvr_service' ) ); ?>" class="widget__more-link"><?php echo esc_html( $instance[ 'more_label' ] ); ?></a>

						<?php endif; ?>

					</p>

				<?php endif; ?>

        	<?php else : ?>

        		<p class="widget__no-results"><?php esc_html_e( 'There are no services', 'lsvr-services' ); ?></p>

        	<?php endif; ?>

        </div>

        <?php // After widget content
        parent::after_widget_content( $args, $instance ); ?>

        <?php

    }

}}

?>