<?php
/**
 * Plugin Name: LSVR Services
 * Description: Adds Service custom post type
 * Version: 1.2.0
 * Author: LSVRthemes
 * Author URI: http://themeforest.net/user/LSVRthemes/portfolio
 * Text Domain: lsvr-services
 * Domain Path: /languages
 * License: http://themeforest.net/licenses
 * License URI: http://themeforest.net/licenses
*/

// Include additional functions and classes
require_once( 'inc/classes/lsvr-cpt.php' );
require_once( 'inc/classes/lsvr-cpt-service.php' );
require_once( 'inc/classes/lsvr-permalink-settings.php' );
require_once( 'inc/classes/lsvr-permalink-settings-services.php' );
require_once( 'inc/core-functions.php' );
require_once( 'inc/blocks-config.php' );

// Load textdomain
load_plugin_textdomain( 'lsvr-services', false, plugin_basename( dirname( __FILE__ ) ) . '/languages/' );

// Register Service CPT
if ( class_exists( 'Lsvr_CPT_Service' ) ) {

	// Register CPT on plugin activation
	if ( ! function_exists( 'lsvr_services_activate_register_service_cpt' ) ) {
		function lsvr_services_activate_register_service_cpt() {
			$lsvr_service_cpt = new Lsvr_CPT_Service();
			$lsvr_service_cpt->activate_cpt();
		}
	}
	register_activation_hook( __FILE__, 'lsvr_services_activate_register_service_cpt' );

	// Register CPT
	$lsvr_service_cpt = new Lsvr_CPT_Service();

}

// Add permalink settings
if ( class_exists( 'Lsvr_Permalink_Settings_Services' ) ) {
	$permalink_settings = new Lsvr_Permalink_Settings_Services();
}

// Register widgets
add_action( 'widgets_init', 'lsvr_services_register_widgets' );
if ( ! function_exists( 'lsvr_services_register_widgets' ) ) {
	function lsvr_services_register_widgets() {

		// Service list
		require_once( 'inc/classes/widgets/lsvr-widget-service-list.php' );
		if ( class_exists( 'Lsvr_Widget_Service_List' ) ) {
			register_widget( 'Lsvr_Widget_Service_List' );
		}

		// Featured service
		require_once( 'inc/classes/widgets/lsvr-widget-service-featured.php' );
		if ( class_exists( 'Lsvr_Widget_Service_Featured' ) ) {
			register_widget( 'Lsvr_Widget_Service_Featured' );
		}

		// Service categories
		require_once( 'inc/classes/widgets/lsvr-widget-service-categories.php' );
		if ( class_exists( 'Lsvr_Widget_Service_Categories' ) ) {
			register_widget( 'Lsvr_Widget_Service_Categories' );
		}

	}
}

// Register shortcodes
add_action( 'init', 'lsvr_services_register_shortcodes' );
if ( ! function_exists( 'lsvr_services_register_shortcodes' ) ) {
	function lsvr_services_register_shortcodes() {

    	// Service List Widget
		require_once( 'inc/classes/shortcodes/lsvr-shortcode-service-list-widget.php' );
		if ( class_exists( 'Lsvr_Shortcode_Service_List_Widget' ) ) {
			add_shortcode( 'lsvr_service_list_widget', array( 'Lsvr_Shortcode_Service_List_Widget', 'shortcode' ) );
		}

    	// Featured Service Widget
		require_once( 'inc/classes/shortcodes/lsvr-shortcode-service-featured-widget.php' );
		if ( class_exists( 'Lsvr_Shortcode_Service_Featured_Widget' ) ) {
			add_shortcode( 'lsvr_service_featured_widget', array( 'Lsvr_Shortcode_Service_Featured_Widget', 'shortcode' ) );
		}

	}
}

?>