<?php

// Register blocks
add_action( 'init', 'lsvr_testimonials_register_blocks', 20 );
if ( ! function_exists( 'lsvr_testimonials_register_blocks' ) ) {
	function lsvr_testimonials_register_blocks() {

		if ( function_exists( 'register_block_type' ) && function_exists( 'lsvr_framework_register_shortcode_block' ) ) {

    		// Testimonial List Widget
			if ( class_exists( 'Lsvr_Shortcode_Testimonial_List_Widget' ) ) {
				lsvr_framework_register_shortcode_block( 'lsvr-testimonials/testimonial-list-widget', array(
					'attributes' => Lsvr_Shortcode_Testimonial_List_Widget::lsvr_shortcode_atts(),
					'render_callback' => array( 'Lsvr_Shortcode_Testimonial_List_Widget', 'shortcode' ),
				));
			}

    		// Featured Testimonial Widget
			if ( class_exists( 'Lsvr_Shortcode_Testimonial_Featured_Widget' ) ) {
				lsvr_framework_register_shortcode_block( 'lsvr-testimonials/testimonial-featured-widget', array(
					'attributes' => Lsvr_Shortcode_Testimonial_Featured_Widget::lsvr_shortcode_atts(),
					'render_callback' => array( 'Lsvr_Shortcode_Testimonial_Featured_Widget', 'shortcode' ),
				));
			}

		}

	}
}

// Register blocks JSON
add_filter( 'lsvr_framework_register_shortcode_blocks_json', 'lsvr_testimonials_register_blocks_json' );
if ( ! function_exists( 'lsvr_testimonials_register_blocks_json' ) ) {
	function lsvr_testimonials_register_blocks_json( $data = array() ) {

		$data = empty( $data ) ? array() : $data;

		if ( function_exists( 'register_block_type' ) && function_exists( 'lsvr_framework_register_shortcode_block_json' ) ) {

			// Testimonial List Widget
			if ( class_exists( 'Lsvr_Shortcode_Testimonial_List_Widget' ) ) {
				array_push( $data, lsvr_framework_register_shortcode_block_json( array(
					'name' => 'lsvr-testimonials/testimonial-list-widget',
					'tag' => 'lsvr_testimonial_list_widget',
					'title' => esc_html__( 'LSVR Testimonials Widget', 'lsvr-testimonials' ),
		        	'description' => esc_html__( 'List of testimonial posts', 'lsvr-testimonials' ),
		        	'category' => 'lsvr-widgets',
		        	'icon' => 'thumbs-up',
		        	'panel_title' => esc_html__( 'Settings', 'lsvr-testimonials' ),
		        	'attributes' => Lsvr_Shortcode_Testimonial_List_Widget::lsvr_shortcode_atts(),
				)));
			}

			// Featured Testimonial Widget
			if ( class_exists( 'Lsvr_Shortcode_Testimonial_Featured_Widget' ) ) {
				array_push( $data, lsvr_framework_register_shortcode_block_json( array(
					'name' => 'lsvr-testimonials/testimonial-featured-widget',
					'tag' => 'lsvr_testimonial_featured_widget',
					'title' => esc_html__( 'LSVR Featured Testimonial Widget', 'lsvr-testimonials' ),
		        	'description' => esc_html__( 'Single testimonial post', 'lsvr-testimonials' ),
		        	'category' => 'lsvr-widgets',
		        	'icon' => 'thumbs-up',
		        	'panel_title' => esc_html__( 'Settings', 'lsvr-testimonials' ),
		        	'attributes' => Lsvr_Shortcode_Testimonial_Featured_Widget::lsvr_shortcode_atts(),
				)));
			}

		}

		return $data;

	}
}

?>