<?php
/**
 * Testimonial post type
 */
if ( ! class_exists( 'Lsvr_CPT_Testimonial' ) && class_exists( 'Lsvr_CPT' ) ) {
    class Lsvr_CPT_Testimonial extends Lsvr_CPT {

		public function __construct() {

			parent::__construct( array(
				'id' => 'lsvr_testimonial',
				'wp_args' => array(
					'labels' => array(
						'name' => esc_html__( 'Testimonials', 'lsvr-testimonials' ),
						'singular_name' => esc_html__( 'Testimonial', 'lsvr-testimonials' ),
						'add_new' => esc_html__( 'Add New Testimonial', 'lsvr-testimonials' ),
						'add_new_item' => esc_html__( 'Add New Testimonial', 'lsvr-testimonials' ),
						'edit_item' => esc_html__( 'Edit Testimonial', 'lsvr-testimonials' ),
						'new_item' => esc_html__( 'Add New Testimonial', 'lsvr-testimonials' ),
						'view_item' => esc_html__( 'View Testimonial', 'lsvr-testimonials' ),
						'search_items' => esc_html__( 'Search testimonials', 'lsvr-testimonials' ),
						'not_found' => esc_html__( 'No testimonials found', 'lsvr-testimonials' ),
						'not_found_in_trash' => esc_html__( 'No testimonials found in trash', 'lsvr-testimonials' ),
					),
					'exclude_from_search' => false,
					'public' => true,
					'supports' => array( 'title', 'editor', 'custom-fields', 'revisions', 'thumbnail', 'author' ),
					'capability_type' => 'post',
					'rewrite' => array( 'slug' => 'testimonials' ),
					'menu_position' => 5,
					'has_archive' => true,
					'show_in_nav_menus' => true,
					'show_in_rest' => true,
					'menu_icon' => 'dashicons-thumbs-up',
				),
			));

			// Additional custom admin functionality
			if ( is_admin() ) {

				// Add Testimonial Settings metabox
				add_action( 'init', array( $this, 'add_testimonial_post_metabox' ) );

			}

		}

		// Add Testimonial Settings metabox
		public function add_testimonial_post_metabox() {
			if ( class_exists( 'Lsvr_Post_Metabox' ) ) {
				$lsvr_testimonial_settings_metabox = new Lsvr_Post_Metabox(array(
					'id' => 'lsvr_testimonial_settings',
					'wp_args' => array(
						'title' => __( 'Testimonial Settings', 'lsvr-testimonial' ),
						'screen' => 'lsvr_testimonial',
					),
					'fields' => array(

						// Author description
						'lsvr_testimonial_author_description' => array(
							'type' => 'text',
							'title' => esc_html__( 'Author Description', 'lsvr-testimonial' ),
							'description' => esc_html__( 'Brief description of testimonial author (for example: Company CEO).', 'lsvr-testimonial' ),
							'priority' => 10,
						),

					),
				));
			}
		}

	}
}

?>