<?php
/**
 * LSVR Testimonial List Widget Shortcode
 */
if ( ! class_exists( 'Lsvr_Shortcode_Testimonial_List_Widget' ) ) {
    class Lsvr_Shortcode_Testimonial_List_Widget {

        public static function shortcode( $atts = array(), $content = null, $tag = '' ) {

            // Merge default atts and received atts
            $args = shortcode_atts(
                array(
                    'title' => '',
                    'limit' => 4,
                    'order' => 'default',
                    'more_label' => '',
                    'id' => '',
                    'className' => '',
                    'editor_view' => false,
                ),
                $atts
            );

            // Check if editor view
            $editor_view = true === $args['editor_view'] || '1' === $args['editor_view'] || 'true' === $args['editor_view'] ? true : false;

            // Element class
            $class_arr = array( 'widget shortcode-widget lsvr_testimonial-list-widget lsvr_testimonial-list-widget--shortcode' );
            if ( true === $editor_view ) {
                array_push( $class_arr, 'lsvr_testimonial-list-widget--editor-view' );
            }
            if ( ! empty( $args['className'] ) ) {
                array_push( $class_arr, $args['className'] );
            }

            ob_start(); ?>

            <?php the_widget( 'Lsvr_Widget_Testimonial_List', array(
                'title' => $args['title'],
                'limit' => $args['limit'],
                'order' => $args['order'],
                'more_label' => $args['more_label'],
                'editor_view' => $args['editor_view'],
            ), array(
                'before_widget' => '<div' . ( ! empty( $args['id'] ) ? ' id="' . esc_attr( $args['id'] ) . '"' : '' ) . ' class="' . esc_attr( implode( ' ', $class_arr ) ) . '"><div class="widget__inner">',
                'after_widget' => '</div></div>',
                'before_title' => '<h3 class="widget__title">',
                'after_title' => '</h3>',
            )); ?>

            <?php return ob_get_clean();

        }

        // Shortcode params
        public static function lsvr_shortcode_atts() {
            return array_merge( array(

                // Title
                array(
                    'name' => 'title',
                    'type' => 'text',
                    'label' => esc_html__( 'Title', 'lsvr-testimonials' ),
                    'description' => esc_html__( 'Title of this section.', 'lsvr-testimonials' ),
                    'default' => esc_html__( 'Latest Testimonials', 'lsvr-testimonials' ),
                    'priority' => 10,
                ),

                // Limit
                array(
                    'name' => 'limit',
                    'type' => 'select',
                    'label' => esc_html__( 'Limit', 'lsvr-testimonials' ),
                    'description' => esc_html__( 'How many testimonials to display.', 'lsvr-testimonials' ),
                    'choices' => array( 0 => esc_html__( 'All', 'lsvr-testimonials' ) ) + range( 0, 20, 1 ),
                    'default' => 4,
                    'priority' => 20,
                ),

                // Order
                array(
                    'name' => 'order',
                    'type' => 'select',
                    'label' => esc_html__( 'Order', 'lsvr-testimonials' ),
                    'description' => esc_html__( 'Order of Testimonial posts.', 'lsvr-testimonials' ),
                    'choices' => array(
                        'default' => esc_html__( 'Default', 'lsvr-testimonials' ),
                        'date_desc' => esc_html__( 'By date, newest first', 'lsvr-testimonials' ),
                        'date_asc' => esc_html__( 'By date, oldest first', 'lsvr-testimonials' ),
                        'title_asc' => esc_html__( 'By title, ascending', 'lsvr-testimonials' ),
                        'title_desc' => esc_html__( 'By title, descending', 'lsvr-testimonials' ),
                        'random' => esc_html__( 'Random', 'lsvr-testimonials' ),
                    ),
                    'default' => 'default',
                    'priority' => 40,
                ),

                // More label
                array(
                    'name' => 'more_label',
                    'type' => 'text',
                    'label' => esc_html__( 'More Link Label', 'lsvr-testimonials' ),
                    'description' => esc_html__( 'Link to testimonials archive. Leave blank to hide.', 'lsvr-testimonials' ),
                    'default' => esc_html__( 'More Testimonials', 'lsvr-testimonials' ),
                    'priority' => 50,
                ),

                // ID
                array(
                    'name' => 'id',
                    'type' => 'text',
                    'label' => esc_html__( 'Unique ID', 'lsvr-testimonials' ),
                    'description' => esc_html__( 'You can use this ID to style this specific element with custom CSS, for example.', 'lsvr-testimonials' ),
                    'priority' => 60,
                ),

            ), apply_filters( 'lsvr_testimonial_list_widget_shortcode_atts', array() ) );

        }

    }
}
?>