<?php
/**
 * LSVR Featured Testimonial widget
 *
 * Display single lsvr_testimonial post
 */
if ( ! class_exists( 'Lsvr_Widget_Testimonial_Featured' ) && class_exists( 'Lsvr_Widget' ) ) {
class Lsvr_Widget_Testimonial_Featured extends Lsvr_Widget {

    public function __construct() {

    	// Init widget
		parent::__construct(array(
			'id' => 'lsvr_testimonials_testimonial_featured',
			'classname' => 'lsvr_testimonial-featured-widget',
			'title' => esc_html__( 'LSVR Featured Testimonial', 'lsvr-testimonials' ),
			'description' => esc_html__( 'Single Testimonial post', 'lsvr-testimonials' ),
			'fields' => array(
				'title' => array(
					'label' => esc_html__( 'Title:', 'lsvr-testimonials' ),
					'type' => 'text',
					'default' => esc_html__( 'Featured Testimonial', 'lsvr-testimonials' ),
				),
				'post' => array(
					'label' => esc_html__( 'Testimonial:', 'lsvr-testimonials' ),
					'description' => esc_html__( 'Choose testimonial to display.', 'lsvr-testimonials' ),
					'type' => 'post',
					'post_type' => 'lsvr_testimonial',
					'default_label' => esc_html__( 'Random', 'lsvr-testimonials' ),
				),
				'more_label' => array(
					'label' => esc_html__( 'More Button Label:', 'lsvr-testimonials' ),
					'description' => esc_html__( 'Link to testimonial post archive. Leave blank to hide.', 'lsvr-testimonials' ),
					'type' => 'text',
					'default' => esc_html__( 'More Testimonials', 'lsvr-testimonials' ),
				),
			),
		));

    }

    function widget( $args, $instance ) {

    	// Get random post
    	if ( empty( $instance['post'] ) || ( ! empty( $instance['post'] ) && 'none' === $instance['post'] ) ) {
    		$testimonial_post = get_posts( array(
    			'post_type' => 'lsvr_testimonial',
    			'orderby' => 'rand',
    			'posts_per_page' => '1'
			));
			$testimonial_post = ! empty( $testimonial_post[0] ) ? $testimonial_post[0] : '';
    	}

    	// Get post
    	else if ( ! empty( $instance['post'] ) ) {
    		$testimonial_post = get_post( $instance['post'] );
    	}

    	?>

        <?php // Before widget content
        parent::before_widget_content( $args, $instance ); ?>

        <div class="widget__content lsvr_testimonial-featured-widget__content">

        	<?php if ( ! empty( $testimonial_post ) ) : ?>

    			<div class="lsvr_testimonial-featured-widget__wrapper">

					<!-- QUOTE : begin -->
  					<blockquote class="lsvr_testimonial-featured-widget__quote">

  						<?php echo $testimonial_post->post_content; ?>

	  					<div class="lsvr_testimonial-featured-widget__footer<?php if ( has_post_thumbnail( $testimonial_post->ID ) ) { echo ' lsvr_testimonial-featured-widget__footer--has-thumb'; } ?>">

		        			<?php if ( has_post_thumbnail( $testimonial_post->ID ) ) : ?>
		        				<p class="lsvr_testimonial-featured-widget__thumb">
		        					<a href="<?php echo esc_url( get_permalink( $testimonial_post->ID ) ); ?>" class="lsvr_testimonial-featured-widget__thumb-link">
		        						<?php echo get_the_post_thumbnail( $testimonial_post->ID, 'thumbnail' ); ?>
		        					</a>
		        				</p>
		        			<?php endif; ?>

		        			<cite class="lsvr_testimonial-featured-widget__author">

		        				<a href="<?php echo esc_url( get_the_permalink( $testimonial_post->ID ) ); ?>" class="lsvr_testimonial-featured-widget__author-link" rel="bookmark">
		        					<?php echo esc_html( get_the_title( $testimonial_post->ID ) ); ?>
		        				</a>

		  						<?php // Description
	        					if ( ! empty( get_post_meta( $testimonial_post->ID, 'lsvr_testimonial_author_description', true ) ) ) : ?>
		  							<span class="lsvr_testimonial-featured-widget__author-description">
		  								<?php echo esc_html( get_post_meta( $testimonial_post->ID, 'lsvr_testimonial_author_description', true ) ); ?>
		  							</span>
	  							<?php endif; ?>

  							</cite>

	  					</div>

  					</blockquote>
  					<!-- QUOTE : end -->

    			</div>

				<?php if ( ! empty( $instance[ 'more_label' ] ) ) : ?>
				<p class="widget__more">
					<a href="<?php echo esc_url( get_post_type_archive_link( 'lsvr_testimonial' ) ); ?>" class="widget__more-link"><?php echo esc_html( $instance[ 'more_label' ] ); ?></a>
				</p>
				<?php endif; ?>

        	<?php else :?>
        		<p class="widget__no-results"><?php esc_html_e( 'There are no testimonials', 'lsvr-testimonials' ); ?></p>
        	<?php endif; ?>

        </div>

        <?php // After widget content
        parent::after_widget_content( $args, $instance ); ?>

        <?php

    }

}}

?>