<?php
/**
 * LSVR Testiomonials widget
 *
 * Display list of lsvr_testimonial posts
 */
if ( ! class_exists( 'Lsvr_Widget_Testimonial_List' ) && class_exists( 'Lsvr_Widget' ) ) {
class Lsvr_Widget_Testimonial_List extends Lsvr_Widget {

    public function __construct() {

    	// Init widget
		parent::__construct(array(
			'id' => 'lsvr_testimonials_testimonial_list',
			'classname' => 'lsvr_testimonial-list-widget',
			'title' => esc_html__( 'LSVR Testimonials', 'lsvr-testimonials' ),
			'description' => esc_html__( 'List of Testimonial posts', 'lsvr-testimonials' ),
			'fields' => array(
				'title' => array(
					'label' => esc_html__( 'Title:', 'lsvr-testimonials' ),
					'type' => 'text',
					'default' => esc_html__( 'Testimonials', 'lsvr-testimonials' ),
				),
				'limit' => array(
					'label' => esc_html__( 'Limit:', 'lsvr-testimonials' ),
					'description' => esc_html__( 'Number of testimonials to display.', 'lsvr-testimonials' ),
					'type' => 'select',
					'choices' => array( 0 => esc_html__( 'All', 'lsvr-testimonials' ), 1, 2, 3, 4, 5, 6, 7, 8, 9, 10 ),
					'default' => 4,
				),
				'order' => array(
					'label' => esc_html__( 'Order:', 'lsvr-testimonials' ),
					'description' => esc_html__( 'Order of Testimonial posts.', 'lsvr-testimonials' ),
					'type' => 'select',
					'choices' => array(
						'default' => esc_html__( 'Default', 'lsvr-testimonials' ),
                        'date_desc' => esc_html__( 'By date, newest first', 'lsvr-testimonials' ),
                        'date_asc' => esc_html__( 'By date, oldest first', 'lsvr-testimonials' ),
                        'title_asc' => esc_html__( 'By title, ascending', 'lsvr-testimonials' ),
                        'title_desc' => esc_html__( 'By title, descending', 'lsvr-testimonials' ),
                        'random' => esc_html__( 'Random', 'lsvr-testimonials' ),
					),
					'default' => 'default',
				),
				'more_label' => array(
					'label' => esc_html__( 'More Button Label:', 'lsvr-testimonials' ),
					'description' => esc_html__( 'Link to testimonial post archive. Leave blank to hide.', 'lsvr-testimonials' ),
					'type' => 'text',
					'default' => esc_html__( 'More Testimonials', 'lsvr-testimonials' ),
				),
			),
		));

    }

    function widget( $args, $instance ) {

		// Set posts limit
		$limit = array_key_exists( 'limit', $instance ) && (int) $instance[ 'limit' ] > 0 ? $instance[ 'limit' ] : 1000;

    	// Get testimonial posts
    	$query_args = array(
    		'post_type' => 'lsvr_testimonial',
    		'posts_per_page' => $limit,
		);
		if ( ! empty( $instance['order'] ) && 'default' !== $instance['order'] ) {
			if ( 'date_desc' == $instance['order'] ) {
				$query_args['orderby'] = 'date';
				$query_args['order'] = 'DESC';
			}
			elseif ( 'date_asc' == $instance['order'] ) {
				$query_args['orderby'] = 'date';
				$query_args['order'] = 'ASC';
			}
			elseif ( 'title_asc' == $instance['order'] ) {
				$query_args['orderby'] = 'title';
				$query_args['order'] = 'ASC';
			}
			elseif ( 'title_desc' == $instance['order'] ) {
				$query_args['orderby'] = 'title';
				$query_args['order'] = 'DESC';
			}
			elseif ( 'random' == $instance['order'] ) {
				$query_args['orderby'] = 'rand';
			}
		}
    	$posts = get_posts( $query_args );

        ?>

        <?php // Before widget content
        parent::before_widget_content( $args, $instance ); ?>

        <div class="widget__content">

        	<?php if ( ! empty( $posts ) ) : ?>

        		<ul class="lsvr_testimonial-list-widget__list">
	        		<?php foreach ( $posts as $testimonial_post ) : ?>

	        			<li class="lsvr_testimonial-list-widget__item<?php if ( has_post_thumbnail( $testimonial_post->ID ) ) { echo ' lsvr_testimonial-list-widget__item--has-thumb'; } ?>">
	        				<div class="lsvr_testimonial-list-widget__item-inner">

								<!-- QUOTE : begin -->
			  					<blockquote class="lsvr_testimonial-list-widget__item-quote">

			  						<?php echo $testimonial_post->post_content; ?>

			  						<div class="lsvr_testimonial-list-widget__item-footer<?php if ( has_post_thumbnail( $testimonial_post->ID ) ) { echo ' lsvr_testimonial-list-widget__item-footer--has-thumb'; } ?>">

					        			<?php if ( has_post_thumbnail( $testimonial_post->ID ) ) : ?>

					        				<p class="lsvr_testimonial-list-widget__item-thumb">
					        					<a href="<?php echo esc_url( get_permalink( $testimonial_post->ID ) ); ?>" class="lsvr_testimonial-list-widget__item-thumb-link">
					        						<?php echo get_the_post_thumbnail( $testimonial_post->ID, 'thumbnail' ); ?>
					        					</a>
					        				</p>

					        			<?php endif; ?>

					        			<cite class="lsvr_testimonial-list-widget__item-author">

			  								<a href="<?php echo esc_url( get_the_permalink() ); ?>" class="lsvr_testimonial-list-widget__item-author-link" rel="bookmark">
			  									<?php echo esc_html( get_the_title( $testimonial_post->ID ) ); ?>
			  								</a>

					  						<?php // Description
				        					if ( ! empty( get_post_meta( $testimonial_post->ID, 'lsvr_testimonial_author_description', true ) ) ) : ?>

					  							<span class="lsvr_testimonial-list-widget__item-author-description">
					  								<?php echo esc_html( get_post_meta( $testimonial_post->ID, 'lsvr_testimonial_author_description', true ) ); ?>
					  							</span>

				  							<?php endif; ?>

			  							</cite>

		  							</div>

			  					</blockquote>
			  					<!-- QUOTE : end -->

		  					</div>
	        			</li>

	        		<?php endforeach; ?>
        		</ul>

				<?php if ( ! empty( $instance[ 'more_label' ] ) ) : ?>

					<p class="widget__more">
						<a href="<?php echo esc_url( get_post_type_archive_link( 'lsvr_testimonial' ) ); ?>" class="widget__more-link"><?php echo esc_html( $instance[ 'more_label' ] ); ?></a>
					</p>

				<?php endif; ?>

        	<?php else : ?>

        		<p class="widget__no-results"><?php esc_html_e( 'There are no testimonials', 'lsvr-testimonials' ); ?></p>

        	<?php endif; ?>

        </div>

        <?php // After widget content
        parent::after_widget_content( $args, $instance ); ?>

        <?php

    }

}}

?>