<?php
/**
 * Plugin Name: LSVR Testimonials
 * Description: Adds Testimonial custom post type
 * Version: 1.2.0
 * Author: LSVRthemes
 * Author URI: http://themeforest.net/user/LSVRthemes/portfolio
 * Text Domain: lsvr-testimonials
 * Domain Path: /languages
 * License: http://themeforest.net/licenses
 * License URI: http://themeforest.net/licenses
*/

// Include additional functions and classes
require_once( 'inc/classes/lsvr-cpt.php' );
require_once( 'inc/classes/lsvr-cpt-testimonial.php' );
require_once( 'inc/classes/lsvr-permalink-settings.php' );
require_once( 'inc/classes/lsvr-permalink-settings-testimonials.php' );
require_once( 'inc/blocks-config.php' );

// Load textdomain
load_plugin_textdomain( 'lsvr-testimonials', false, plugin_basename( dirname( __FILE__ ) ) . '/languages/' );

// Register Testimonial CPT
if ( class_exists( 'Lsvr_CPT_Testimonial' ) ) {

	// Register CPT on plugin activation
	if ( ! function_exists( 'lsvr_testimonials_activate_register_testimonial_cpt' ) ) {
		function lsvr_testimonials_activate_register_testimonial_cpt() {
			$lsvr_testimonial_cpt = new Lsvr_CPT_Testimonial();
			$lsvr_testimonial_cpt->activate_cpt();
		}
	}
	register_activation_hook( __FILE__, 'lsvr_testimonials_activate_register_testimonial_cpt' );

	// Register CPT
	$lsvr_testimonial_cpt = new Lsvr_CPT_testimonial();

}

// Add permalink settings
if ( class_exists( 'Lsvr_Permalink_Settings_Testimonials' ) ) {
	$permalink_settings = new Lsvr_Permalink_Settings_Testimonials();
}

// Register widgets
add_action( 'widgets_init', 'lsvr_testimonials_register_widgets' );
if ( ! function_exists( 'lsvr_testimonials_register_widgets' ) ) {
	function lsvr_testimonials_register_widgets() {

		// Featured testimonial
		require_once( 'inc/classes/widgets/lsvr-widget-testimonial-featured.php' );
		if ( class_exists( 'Lsvr_Widget_Testimonial_Featured' ) ) {
			register_widget( 'Lsvr_Widget_Testimonial_Featured' );
		}

		// Testimonials list
		require_once( 'inc/classes/widgets/lsvr-widget-testimonial-list.php' );
		if ( class_exists( 'Lsvr_Widget_Testimonial_List' ) ) {
			register_widget( 'Lsvr_Widget_Testimonial_List' );
		}

	}
}

// Register shortcodes
add_action( 'init', 'lsvr_testimonials_register_shortcodes' );
if ( ! function_exists( 'lsvr_testimonials_register_shortcodes' ) ) {
	function lsvr_testimonials_register_shortcodes() {

    	// Testimonial List Widget
		require_once( 'inc/classes/shortcodes/lsvr-shortcode-testimonial-list-widget.php' );
		if ( class_exists( 'Lsvr_Shortcode_Testimonial_List_Widget' ) ) {
			add_shortcode( 'lsvr_testimonial_list_widget', array( 'Lsvr_Shortcode_Testimonial_List_Widget', 'shortcode' ) );
		}

    	// Featured Testimonial Widget
		require_once( 'inc/classes/shortcodes/lsvr-shortcode-testimonial-featured-widget.php' );
		if ( class_exists( 'Lsvr_Shortcode_Testimonial_Featured_Widget' ) ) {
			add_shortcode( 'lsvr_testimonial_featured_widget', array( 'Lsvr_Shortcode_Testimonial_Featured_Widget', 'shortcode' ) );
		}

	}
}

?>