<?php

// Register blocks
add_action( 'init', 'lsvr_portfolio_register_blocks', 20 );
if ( ! function_exists( 'lsvr_portfolio_register_blocks' ) ) {
	function lsvr_portfolio_register_blocks() {

		if ( function_exists( 'register_block_type' ) && function_exists( 'lsvr_framework_register_shortcode_block' ) ) {

    		// Project List Widget
			if ( class_exists( 'Lsvr_Shortcode_Project_List_Widget' ) ) {
				lsvr_framework_register_shortcode_block( 'lsvr-portfolio/project-list-widget', array(
					'attributes' => Lsvr_Shortcode_Project_List_Widget::lsvr_shortcode_atts(),
					'render_callback' => array( 'Lsvr_Shortcode_Project_List_Widget', 'shortcode' ),
				));
			}

    		// Featured Project Widget
			if ( class_exists( 'Lsvr_Shortcode_Project_Featured_Widget' ) ) {
				lsvr_framework_register_shortcode_block( 'lsvr-portfolio/project-featured-widget', array(
					'attributes' => Lsvr_Shortcode_Project_Featured_Widget::lsvr_shortcode_atts(),
					'render_callback' => array( 'Lsvr_Shortcode_Project_Featured_Widget', 'shortcode' ),
				));
			}

		}

	}
}

// Register blocks JSON
add_filter( 'lsvr_framework_register_shortcode_blocks_json', 'lsvr_portfolio_register_blocks_json' );
if ( ! function_exists( 'lsvr_portfolio_register_blocks_json' ) ) {
	function lsvr_portfolio_register_blocks_json( $data = array() ) {

		$data = empty( $data ) ? array() : $data;

		if ( function_exists( 'register_block_type' ) && function_exists( 'lsvr_framework_register_shortcode_block_json' ) ) {

			// Project List Widget
			if ( class_exists( 'Lsvr_Shortcode_Project_List_Widget' ) ) {
				array_push( $data, lsvr_framework_register_shortcode_block_json( array(
					'name' => 'lsvr-portfolio/project-list-widget',
					'tag' => 'lsvr_project_list_widget',
					'title' => esc_html__( 'LSVR Portfolio Widget', 'lsvr-portfolio' ),
		        	'description' => esc_html__( 'List of project posts', 'lsvr-portfolio' ),
		        	'category' => 'lsvr-widgets',
		        	'icon' => 'portfolio',
		        	'panel_title' => esc_html__( 'Settings', 'lsvr-portfolio' ),
		        	'attributes' => Lsvr_Shortcode_Project_List_Widget::lsvr_shortcode_atts(),
				)));
			}

			// Featured Project Widget
			if ( class_exists( 'Lsvr_Shortcode_Project_Featured_Widget' ) ) {
				array_push( $data, lsvr_framework_register_shortcode_block_json( array(
					'name' => 'lsvr-portfolio/project-featured-widget',
					'tag' => 'lsvr_project_featured_widget',
					'title' => esc_html__( 'LSVR Featured Project Widget', 'lsvr-portfolio' ),
		        	'description' => esc_html__( 'Single project post', 'lsvr-portfolio' ),
		        	'category' => 'lsvr-widgets',
		        	'icon' => 'portfolio',
		        	'panel_title' => esc_html__( 'Settings', 'lsvr-portfolio' ),
		        	'attributes' => Lsvr_Shortcode_Project_Featured_Widget::lsvr_shortcode_atts(),
				)));
			}

		}

		return $data;

	}
}

?>