<?php
/**
 * Project post type
 */
if ( ! class_exists( 'Lsvr_CPT_Project' ) && class_exists( 'Lsvr_CPT' ) ) {
    class Lsvr_CPT_Project extends Lsvr_CPT {

		public function __construct() {

			parent::__construct( array(
				'id' => 'lsvr_project',
				'wp_args' => array(
					'labels' => array(
						'name' => esc_html__( 'Portfolio', 'lsvr-portfolio' ),
						'singular_name' => esc_html__( 'Project', 'lsvr-portfolio' ),
						'add_new' => esc_html__( 'Add New Project', 'lsvr-portfolio' ),
						'add_new_item' => esc_html__( 'Add New Project', 'lsvr-portfolio' ),
						'edit_item' => esc_html__( 'Edit Project', 'lsvr-portfolio' ),
						'new_item' => esc_html__( 'Add New Project', 'lsvr-portfolio' ),
						'view_item' => esc_html__( 'View Project', 'lsvr-portfolio' ),
						'search_items' => esc_html__( 'Search projects', 'lsvr-portfolio' ),
						'not_found' => esc_html__( 'No projects found', 'lsvr-portfolio' ),
						'not_found_in_trash' => esc_html__( 'No projects found in trash', 'lsvr-portfolio' ),
					),
					'exclude_from_search' => false,
					'public' => true,
					'supports' => array( 'title', 'editor', 'custom-fields', 'revisions', 'excerpt', 'thumbnail', 'author' ),
					'capability_type' => 'post',
					'rewrite' => array( 'slug' => 'portfolio' ),
					'menu_position' => 5,
					'has_archive' => true,
					'show_in_nav_menus' => true,
					'show_in_rest' => true,
					'menu_icon' => 'dashicons-portfolio',
				),
			));

			// Add Category taxonomy
			$this->add_taxonomy(array(
				'id' => 'lsvr_project_cat',
				'wp_args' => array(
					'labels' => array(
						'name' => esc_html__( 'Project Categories', 'lsvr-portfolio' ),
						'singular_name' => esc_html__( 'Project Category', 'lsvr-portfolio' ),
						'search_items' => esc_html__( 'Search Project Categories', 'lsvr-portfolio' ),
						'popular_items' => esc_html__( 'Popular Project Categories', 'lsvr-portfolio' ),
						'all_items' => esc_html__( 'All Project Categories', 'lsvr-portfolio' ),
						'parent_item' => esc_html__( 'Parent Project Category', 'lsvr-portfolio' ),
						'parent_item_colon' => esc_html__( 'Parent Project Category:', 'lsvr-portfolio' ),
						'edit_item' => esc_html__( 'Edit Project Category', 'lsvr-portfolio' ),
						'update_item' => esc_html__( 'Update Project Category', 'lsvr-portfolio' ),
						'add_new_item' => esc_html__( 'Add New Project Category', 'lsvr-portfolio' ),
						'new_item_name' => esc_html__( 'New Project Category Name', 'lsvr-portfolio' ),
						'separate_items_with_commas' => esc_html__( 'Separate project categories by comma', 'lsvr-portfolio' ),
						'add_or_remove_items' => esc_html__( 'Add or remove project categories', 'lsvr-portfolio' ),
						'choose_from_most_used' => esc_html__( 'Choose from the most used project categories', 'lsvr-portfolio' ),
						'menu_name' => esc_html__( 'Project Categories', 'lsvr-portfolio' )
					),
					'public' => true,
					'show_in_nav_menus' => true,
					'show_ui' => true,
					'show_admin_column' => true,
					'show_tagcloud' => true,
					'hierarchical' => true,
					'rewrite' => array( 'slug' => 'project-category' ),
					'query_var' => true,
					'show_in_rest' => true,
				),
				'args' => array(
					'admin_tax_filter' => true,
				),
			));

			// Add Tag taxonomy
			$this->add_taxonomy(array(
				'id' => 'lsvr_project_tag',
				'wp_args' => array(
					'labels' => array(
						'name' => esc_html__( 'Project Tags', 'lsvr-portfolio' ),
						'singular_name' => esc_html__( 'Project Tag', 'lsvr-portfolio' ),
						'search_items' => esc_html__( 'Search Project Tags', 'lsvr-portfolio' ),
						'popular_items' => esc_html__( 'Popular Project Tags', 'lsvr-portfolio' ),
						'all_items' => esc_html__( 'All Project Tags', 'lsvr-portfolio' ),
						'parent_item' => esc_html__( 'Parent Project Tag', 'lsvr-portfolio' ),
						'parent_item_colon' => esc_html__( 'Parent Project Tag:', 'lsvr-portfolio' ),
						'edit_item' => esc_html__( 'Edit Project Tag', 'lsvr-portfolio' ),
						'update_item' => esc_html__( 'Update Project Tag', 'lsvr-portfolio' ),
						'add_new_item' => esc_html__( 'Add New Project Tag', 'lsvr-portfolio' ),
						'new_item_name' => esc_html__( 'New Project Tag Name', 'lsvr-portfolio' ),
						'separate_items_with_commas' => esc_html__( 'Separate project tags by comma', 'lsvr-portfolio' ),
						'add_or_remove_items' => esc_html__( 'Add or remove project tags', 'lsvr-portfolio' ),
						'choose_from_most_used' => esc_html__( 'Choose from the most used project tags', 'lsvr-portfolio' ),
						'menu_name' => esc_html__( 'Project Tags', 'lsvr-portfolio' )
					),
					'public' => true,
					'show_in_nav_menus' => true,
					'show_ui' => true,
					'show_admin_column' => true,
					'show_tagcloud' => true,
					'hierarchical' => false,
					'rewrite' => array( 'slug' => 'project-tag' ),
					'query_var' => true,
					'show_in_rest' => true,
				),
				'args' => array(
					'admin_tax_filter' => true,
				),
			));

			// Additional custom admin functionality
			if ( is_admin() ) {

				// Add metaboxes
				add_action( 'init', array( $this, 'add_project_post_metabox' ) );

			}

		}

		// Add Document Settings metabox
		public function add_project_post_metabox() {
			if ( class_exists( 'Lsvr_Post_Metabox' ) ) {

				// Project settings metabox
				$lsvr_listing_settings_metabox = new Lsvr_Post_Metabox(array(
					'id' => 'lsvr_project_settings',
					'wp_args' => array(
						'title' => __( 'Project Settings', 'lsvr-portfolio' ),
						'screen' => 'lsvr_project',
					),
					'fields' => array(

						// Custom Field 1 Title
						'lsvr_project_custom_field_1_title' => array(
							'title' => esc_html__( 'Custom Field 1 Title', 'lsvr-portfolio' ),
							'description' => esc_html__( 'Custom fields can be used for adding some extra info for this project. For example author name or URL.', 'lsvr-portfolio' ),
							'type' => 'text',
							'priority' => 1010,
						),

						// Custom Field 2 Text
						'lsvr_project_custom_field_1_text' => array(
							'title' => esc_html__( 'Custom Field 1 Text', 'lsvr-portfolio' ),
							'type' => 'textarea',
							'priority' => 1020,
						),

						// Custom Field 2 Title
						'lsvr_project_custom_field_2_title' => array(
							'title' => esc_html__( 'Custom Field 2 Title', 'lsvr-portfolio' ),
							'type' => 'text',
							'priority' => 1030,
						),

						// Custom Field 2 Text
						'lsvr_project_custom_field_2_text' => array(
							'title' => esc_html__( 'Custom Field 2 Text', 'lsvr-portfolio' ),
							'type' => 'textarea',
							'priority' => 1040,
						),

						// Custom Field 3 Title
						'lsvr_project_custom_field_3_title' => array(
							'title' => esc_html__( 'Custom Field 3 Title', 'lsvr-portfolio' ),
							'type' => 'text',
							'priority' => 1050,
						),

						// Custom Field 3 Text
						'lsvr_project_custom_field_3_text' => array(
							'title' => esc_html__( 'Custom Field 3 Text', 'lsvr-portfolio' ),
							'type' => 'textarea',
							'priority' => 1060,
						),

						// Custom Field 4 Title
						'lsvr_project_custom_field_4_title' => array(
							'title' => esc_html__( 'Custom Field 4 Title', 'lsvr-portfolio' ),
							'type' => 'text',
							'priority' => 1070,
						),

						// Custom Field 4 Text
						'lsvr_project_custom_field_4_text' => array(
							'title' => esc_html__( 'Custom Field 4 Text', 'lsvr-portfolio' ),
							'type' => 'textarea',
							'priority' => 1080,
						),

					),
				));

				// Project gallery metabox
				$lsvr_project_gallery_metabox = new Lsvr_Post_Metabox(array(
					'id' => 'lsvr_project_gallery',
					'wp_args' => array(
						'title' => __( 'Project Gallery', 'lsvr-portfolio' ),
						'screen' => 'lsvr_project',
					),
					'fields' => array(

						// Gallery
						'lsvr_project_images' => array(
							'type' => 'gallery',
							'description' => esc_html__( 'You can add some additional images for this project which will be displayed on its detail page.', 'lsvr-portfolio' ),
							'multiple' => true,
							'select_btn_label' => esc_html__( 'Manage Gallery Images', 'lsvr-portfolio' ),
							'media_type' => array( 'image' ),
							'priority' => 10,
						),

					),
				));

			}
		}

	}
}

?>