<?php
/**
 * LSVR Project List Widget Shortcode
 */
if ( ! class_exists( 'Lsvr_Shortcode_Project_List_Widget' ) ) {
    class Lsvr_Shortcode_Project_List_Widget {

        public static function shortcode( $atts = array(), $content = null, $tag = '' ) {

            // Merge default atts and received atts
            $args = shortcode_atts(
                array(
                    'title' => '',
                    'category' => 0,
                    'limit' => 4,
                    'order' => 'default',
                    'show_date' => 'true',
                    'show_category' => 'true',
                    'more_label' => '',
                    'id' => '',
                    'className' => '',
                    'editor_view' => false,
                ),
                $atts
            );

            // Check if editor view
            $editor_view = true === $args['editor_view'] || '1' === $args['editor_view'] || 'true' === $args['editor_view'] ? true : false;

            // Element class
            $class_arr = array( 'widget shortcode-widget lsvr_project-list-widget lsvr_project-list-widget--shortcode' );
            if ( true === $editor_view ) {
                array_push( $class_arr, 'lsvr_project-list-widget--editor-view' );
            }
            if ( ! empty( $args['className'] ) ) {
                array_push( $class_arr, $args['className'] );
            }

            ob_start(); ?>

            <?php the_widget( 'Lsvr_Widget_Project_List', array(
                'title' => $args['title'],
                'category' => $args['category'],
                'limit' => $args['limit'],
                'order' => $args['order'],
                'show_date' => $args['show_date'],
                'show_category' => $args['show_category'],
                'more_label' => $args['more_label'],
                'editor_view' => $args['editor_view'],
            ), array(
                'before_widget' => '<div' . ( ! empty( $args['id'] ) ? ' id="' . esc_attr( $args['id'] ) . '"' : '' ) . ' class="' . esc_attr( implode( ' ', $class_arr ) ) . '"><div class="widget__inner">',
                'after_widget' => '</div></div>',
                'before_title' => '<h3 class="widget__title">',
                'after_title' => '</h3>',
            )); ?>

            <?php return ob_get_clean();

        }

        // Shortcode params
        public static function lsvr_shortcode_atts() {
            return array_merge( array(

                // Title
                array(
                    'name' => 'title',
                    'type' => 'text',
                    'label' => esc_html__( 'Title', 'lsvr-portfolio' ),
                    'description' => esc_html__( 'Title of this section.', 'lsvr-portfolio' ),
                    'default' => esc_html__( 'Latest Projects', 'lsvr-portfolio' ),
                    'priority' => 10,
                ),

                // Category
                array(
                    'name' => 'category',
                    'type' => 'taxonomy',
                    'tax' => 'lsvr_project_cat',
                    'label' => esc_html__( 'Category', 'lsvr-portfolio' ),
                    'description' => esc_html__( 'Display projects from a specific category.', 'lsvr-portfolio' ),
                    'priority' => 20,
                ),

                // Limit
                array(
                    'name' => 'limit',
                    'type' => 'select',
                    'label' => esc_html__( 'Limit', 'lsvr-portfolio' ),
                    'description' => esc_html__( 'How many projects to display.', 'lsvr-portfolio' ),
                    'choices' => array( 0 => esc_html__( 'All', 'lsvr-portfolio' ) ) + range( 0, 20, 1 ),
                    'default' => 4,
                    'priority' => 30,
                ),

                // Order
                array(
                    'name' => 'order',
                    'type' => 'select',
                    'label' => esc_html__( 'Order', 'lsvr-portfolio' ),
                    'description' => esc_html__( 'Order of project posts.', 'lsvr-portfolio' ),
                    'choices' => array(
                        'default' => esc_html__( 'Default', 'lsvr-portfolio' ),
                        'date_desc' => esc_html__( 'By date, newest first', 'lsvr-portfolio' ),
                        'date_asc' => esc_html__( 'By date, oldest first', 'lsvr-portfolio' ),
                        'title_asc' => esc_html__( 'By title, ascending', 'lsvr-portfolio' ),
                        'title_desc' => esc_html__( 'By title, descending', 'lsvr-portfolio' ),
                        'random' => esc_html__( 'Random', 'lsvr-portfolio' ),
                    ),
                    'default' => 'default',
                    'priority' => 40,
                ),

                // Display date
                array(
                    'name' => 'show_date',
                    'type' => 'checkbox',
                    'label' => esc_html__( 'Display Date', 'lsvr-portfolio' ),
                    'default' => true,
                    'priority' => 50,
                ),

                // Display category
                array(
                    'name' => 'show_category',
                    'type' => 'checkbox',
                    'label' => esc_html__( 'Display Category', 'lsvr-portfolio' ),
                    'default' => true,
                    'priority' => 60,
                ),

                // More label
                array(
                    'name' => 'more_label',
                    'type' => 'text',
                    'label' => esc_html__( 'More Link Label', 'lsvr-portfolio' ),
                    'description' => esc_html__( 'Link to portfolio archive. Leave blank to hide.', 'lsvr-portfolio' ),
                    'default' => esc_html__( 'More Projects', 'lsvr-portfolio' ),
                    'priority' => 70,
                ),

                // ID
                array(
                    'name' => 'id',
                    'type' => 'text',
                    'label' => esc_html__( 'Unique ID', 'lsvr-portfolio' ),
                    'description' => esc_html__( 'You can use this ID to style this specific element with custom CSS, for example.', 'lsvr-portfolio' ),
                    'priority' => 200,
                ),

            ), apply_filters( 'lsvr_project_list_widget_shortcode_atts', array() ) );
        }

    }
}
?>