<?php
/**
 * LSVR Project Categories widget
 *
 * Display list of lsvr_project_cat tax terms
 */
if ( ! class_exists( 'Lsvr_Widget_Project_Categories' ) && class_exists( 'Lsvr_Widget' ) ) {
class Lsvr_Widget_Project_Categories extends Lsvr_Widget {

    public function __construct() {

    	// Init widget
		parent::__construct(array(
			'id' => 'lsvr_portfolio_project_categories',
			'classname' => 'lsvr_project-categories-widget',
			'title' => esc_html__( 'LSVR Project Categories', 'lsvr-portfolio' ),
			'description' => esc_html__( 'List of Project categories', 'lsvr-portfolio' ),
			'fields' => array(
				'title' => array(
					'label' => esc_html__( 'Title:', 'lsvr-portfolio' ),
					'type' => 'text',
					'default' => esc_html__( 'Project Categories', 'lsvr-portfolio' ),
				),
			),
		));

    }

    function widget( $args, $instance ) {
        ?>

        <?php // Before widget content
        parent::before_widget_content( $args, $instance ); ?>

        <div class="widget__content">

			<ul class="root">
	        	<?php wp_list_categories(array(
					'title_li' => '',
					'taxonomy' => 'lsvr_project_cat',
					'show_count' => false,
				)); ?>
			</ul>

        </div>

        <?php // After widget content
        parent::after_widget_content( $args, $instance ); ?>

        <?php

    }

}}

?>