<?php
/**
 * LSVR Featured Project widget
 *
 * Single lsvr_project post
 */
if ( ! class_exists( 'Lsvr_Widget_Project_Featured' ) && class_exists( 'Lsvr_Widget' ) ) {
class Lsvr_Widget_Project_Featured extends Lsvr_Widget {

    public function __construct() {

    	// Init widget
		parent::__construct(array(
			'id' => 'lsvr_portfolio_project_featured',
			'classname' => 'lsvr_project-featured-widget',
			'title' => esc_html__( 'LSVR Featured Project', 'lsvr-portfolio' ),
			'description' => esc_html__( 'Single Project post', 'lsvr-portfolio' ),
			'fields' => array(
				'title' => array(
					'label' => esc_html__( 'Title:', 'lsvr-portfolio' ),
					'type' => 'text',
					'default' => esc_html__( 'Featured Project', 'lsvr-portfolio' ),
				),
				'post' => array(
					'label' => esc_html__( 'Project:', 'lsvr-portfolio' ),
					'description' => esc_html__( 'Choose project to display.', 'lsvr-portfolio' ),
					'type' => 'post',
					'post_type' => 'lsvr_project',
					'default_label' => esc_html__( 'Random', 'lsvr-portfolio' ),
				),
				'show_date' => array(
					'label' => esc_html__( 'Display Date', 'lsvr-portfolio' ),
					'type' => 'checkbox',
					'default' => 'true',
				),
				'show_category' => array(
					'label' => esc_html__( 'Display Category', 'lsvr-portfolio' ),
					'type' => 'checkbox',
					'default' => 'true',
				),
				'show_excerpt' => array(
					'label' => esc_html__( 'Display Excerpt', 'lsvr-portfolio' ),
					'type' => 'checkbox',
					'default' => 'true',
				),
				'more_label' => array(
					'label' => esc_html__( 'More Button Label:', 'lsvr-portfolio' ),
					'description' => esc_html__( 'Link to project post archive. Leave blank to hide.', 'lsvr-portfolio' ),
					'type' => 'text',
					'default' => esc_html__( 'More Projects', 'lsvr-portfolio' ),
				),
			),
		));

    }

    function widget( $args, $instance ) {

    	// Show date
    	$show_date = ! empty( $instance['show_date'] ) && ( true === $instance['show_date'] || 'true' === $instance['show_date'] || '1' === $instance['show_date'] ) ? true : false;

		// Show category
    	$show_category = ! empty( $instance['show_category'] ) && ( true === $instance['show_category'] || 'true' === $instance['show_category'] || '1' === $instance['show_category'] ) ? true : false;

		// Show excerpt
    	$show_excerpt = ! empty( $instance['show_excerpt'] ) && ( true === $instance['show_excerpt'] || 'true' === $instance['show_excerpt'] || '1' === $instance['show_excerpt'] ) ? true : false;

    	// Get random post
    	if ( empty( $instance['post'] ) || ( ! empty( $instance['post'] ) && 'none' === $instance['post'] ) ) {
    		$project_post = get_posts( array(
    			'post_type' => 'lsvr_project',
    			'orderby' => 'rand',
    			'posts_per_page' => '1'
			));
			$project_post = ! empty( $project_post[0] ) ? $project_post[0] : '';
    	}

    	// Get post
    	else if ( ! empty( $instance['post'] ) ) {
    		$project_post = get_post( $instance['post'] );
    	}

        ?>

        <?php // Before widget content
        parent::before_widget_content( $args, $instance ); ?>

        <div class="widget__content lsvr_project-featured-widget__content">

        	<?php if ( ! empty( $project_post ) ) : ?>

    			<?php // Thumbnail
    			$project_thumb = lsvr_portfolio_get_project_thumb( $project_post->ID );
    			if ( ! empty( $project_thumb ) ) : ?>
    				<p class="lsvr_project-featured-widget__thumb">
    					<a href="<?php echo esc_url( get_permalink( $project_post->ID ) ); ?>" class="lsvr_project-featured-widget__thumb-link">
    						<img src="<?php echo esc_url( $project_thumb['medium_url'] ); ?>"
    							title="<?php echo esc_attr( $project_thumb['title'] ); ?>"
    							alt="<?php echo esc_attr( $project_thumb['alt'] ); ?>">
    					</a>
    				</p>
    			<?php endif; ?>

    			<div class="lsvr_project-featured-widget__content-inner">

	    			<h4 class="lsvr_project-featured-widget__title">
	    				<a href="<?php echo esc_url( get_permalink( $project_post->ID ) ); ?>" class="lsvr_project-featured-widget__title-link">
	    					<?php echo get_the_title( $project_post->ID ); ?>
	    				</a>
	    			</h4>

					<?php // Date
					if ( true === $show_date ) : ?>
						<p class="lsvr_project-featured-widget__date">
							<time datetime="<?php echo esc_attr( get_the_time( 'c', $project_post->ID ) ); ?>">
								<?php echo esc_html( date_i18n( get_option( 'date_format' ), strtotime( $project_post->post_date ) ) ); ?>
							</time>
						</p>
					<?php endif; ?>

					<?php // Category
					$terms = wp_get_post_terms( $project_post->ID, 'lsvr_project_cat' );
					$category_html = '';
					if ( ! empty( $terms ) ) {
						foreach ( $terms as $term ) {
							$category_html .= '<a href="' . esc_url( get_term_link( $term->term_id, 'lsvr_project_cat' ) ) . '" class="lsvr_project-featured-widget__category-link">' . $term->name . '</a>';
							$category_html .= $term !== end( $terms ) ? ', ' : '';
						}
					}
					if ( true === $show_category && ! empty( $category_html ) ) : ?>
						<p class="lsvr_project-featured-widget__category">
							<?php echo sprintf( esc_html__( 'in %s', 'lsvr-portfolio' ), $category_html ); ?>
						</p>
					<?php endif; ?>

					<?php // Excerpt
					if ( true === $show_excerpt && has_excerpt( $project_post->ID ) ) : ?>
						<div class="lsvr_project-featured-widget__excerpt">
							<?php echo wpautop( get_the_excerpt( $project_post->ID ) ); ?>
						</div>
					<?php endif; ?>

					<?php if ( ! empty( $instance[ 'more_label' ] ) ) : ?>
					<p class="widget__more">
						<a href="<?php echo esc_url( get_post_type_archive_link( 'lsvr_project' ) ); ?>" class="widget__more-link"><?php echo esc_html( $instance[ 'more_label' ] ); ?></a>
					</p>
					<?php endif; ?>

				</div>

        	<?php else : ?>
        		<p class="widget__no-results"><?php esc_html_e( 'There are no projects', 'lsvr-portfolio' ); ?></p>
        	<?php endif; ?>

        </div>

        <?php // After widget content
        parent::after_widget_content( $args, $instance ); ?>

        <?php

    }

}}

?>