<?php
/**
 * LSVR Portfolio widget
 *
 * Display list of lsvr_project posts
 */
if ( ! class_exists( 'Lsvr_Widget_Project_List' ) && class_exists( 'Lsvr_Widget' ) ) {
class Lsvr_Widget_Project_List extends Lsvr_Widget {

    public function __construct() {

    	// Init widget
		parent::__construct(array(
			'id' => 'lsvr_portfolio_project_list',
			'classname' => 'lsvr_project-list-widget',
			'title' => esc_html__( 'LSVR Portfolio', 'lsvr-portfolio' ),
			'description' => esc_html__( 'List of Project posts', 'lsvr-portfolio' ),
			'fields' => array(
				'title' => array(
					'label' => esc_html__( 'Title:', 'lsvr-portfolio' ),
					'type' => 'text',
					'default' => esc_html__( 'Portfolio', 'lsvr-portfolio' ),
				),
				'category' => array(
					'label' => esc_html__( 'Category:', 'lsvr-portfolio' ),
					'description' => esc_html__( 'Display projects only from a certain category.', 'lsvr-portfolio' ),
					'type' => 'taxonomy',
					'taxonomy' => 'lsvr_project_cat',
					'default_label' => esc_html__( 'None', 'lsvr-portfolio' ),
				),
				'limit' => array(
					'label' => esc_html__( 'Limit:', 'lsvr-portfolio' ),
					'description' => esc_html__( 'Number of projects to display.', 'lsvr-portfolio' ),
					'type' => 'select',
					'choices' => array( 0 => esc_html__( 'All', 'lsvr-portfolio' ), 1, 2, 3, 4, 5, 6, 7, 8, 9, 10 ),
					'default' => 4,
				),
				'order' => array(
					'label' => esc_html__( 'Order:', 'lsvr-portfolio' ),
					'description' => esc_html__( 'Order of project posts.', 'lsvr-portfolio' ),
					'type' => 'select',
					'choices' => array(
						'default' => esc_html__( 'Default', 'lsvr-portfolio' ),
                        'date_desc' => esc_html__( 'By date, newest first', 'lsvr-portfolio' ),
                        'date_asc' => esc_html__( 'By date, oldest first', 'lsvr-portfolio' ),
                        'title_asc' => esc_html__( 'By title, ascending', 'lsvr-portfolio' ),
                        'title_desc' => esc_html__( 'By title, descending', 'lsvr-portfolio' ),
                        'random' => esc_html__( 'Random', 'lsvr-portfolio' ),
					),
					'default' => 'default',
				),
				'show_date' => array(
					'label' => esc_html__( 'Display Date', 'lsvr-portfolio' ),
					'type' => 'checkbox',
					'default' => 'true',
				),
				'show_category' => array(
					'label' => esc_html__( 'Display Category', 'lsvr-portfolio' ),
					'type' => 'checkbox',
					'default' => 'true',
				),
				'more_label' => array(
					'label' => esc_html__( 'More Button Label:', 'lsvr-portfolio' ),
					'description' => esc_html__( 'Link to project post archive. Leave blank to hide.', 'lsvr-portfolio' ),
					'type' => 'text',
					'default' => esc_html__( 'More Projects', 'lsvr-portfolio' ),
				),
			),
		));

    }

    function widget( $args, $instance ) {

    	// Show date
    	$show_date = ! empty( $instance['show_date'] ) && ( true === $instance['show_date'] || 'true' === $instance['show_date'] || '1' === $instance['show_date'] ) ? true : false;

		// Show category
    	$show_category = ! empty( $instance['show_category'] ) && ( true === $instance['show_category'] || 'true' === $instance['show_category'] || '1' === $instance['show_category'] ) ? true : false;

    	// Get project posts
    	$query_args = array(
    		'limit' => array_key_exists( 'limit', $instance ) ? $instance[ 'limit' ] : 4,
		);
		if ( ! empty( $instance['category'] ) && 'none' !== $instance['category'] ) {
			$query_args['category'] = $instance['category'];
		}
		if ( ! empty( $instance['order'] ) && 'default' !== $instance['order'] ) {
			if ( 'date_desc' == $instance['order'] ) {
				$query_args['orderby'] = 'date';
				$query_args['order'] = 'DESC';
			}
			elseif ( 'date_asc' == $instance['order'] ) {
				$query_args['orderby'] = 'date';
				$query_args['order'] = 'ASC';
			}
			elseif ( 'title_asc' == $instance['order'] ) {
				$query_args['orderby'] = 'title';
				$query_args['order'] = 'ASC';
			}
			elseif ( 'title_desc' == $instance['order'] ) {
				$query_args['orderby'] = 'title';
				$query_args['order'] = 'DESC';
			}
			elseif ( 'random' == $instance['order'] ) {
				$query_args['orderby'] = 'rand';
			}
		}
    	$posts = lsvr_portfolio_get_projects( $query_args );

        ?>

        <?php // Before widget content
        parent::before_widget_content( $args, $instance ); ?>

        <div class="widget__content">

        	<?php if ( ! empty( $posts ) ) : ?>

        		<ul class="lsvr_project-list-widget__list">
	        		<?php foreach ( $posts as $project_id => $project_post ) : ?>

						<?php $project_thumb = lsvr_portfolio_get_project_thumb( $project_id );
	        			$project_post = $project_post['post']; ?>

	        			<li class="lsvr_project-list-widget__item<?php if ( ! empty( $project_thumb ) ) { echo ' lsvr_project-list-widget__item--has-thumb'; } ?>">
	        				<div class="lsvr_project-list-widget__item-inner">

								<?php if ( ! empty( $project_thumb['thumb_url'] ) ) : ?>

									<p class="lsvr_project-list-widget__item-thumb">
										<a href="<?php echo esc_url( get_permalink( $project_id ) ); ?>" class="lsvr_project-list-widget__item-thumb-link">
											<img src="<?php echo esc_url( $project_thumb['thumb_url'] ); ?>"
												class="lsvr_project-list-widget__item-thumb-img"
												title="<?php echo esc_attr( $project_post->post_title ); ?>"
												alt="<?php echo esc_attr( $project_thumb['alt'] ); ?>">
										</a>
									</p>

								<?php endif; ?>

								<div class="lsvr_project-list-widget__item-content">

									<h4 class="lsvr_project-list-widget__item-title">
										<a href="<?php echo esc_url( get_permalink( $project_id ) ); ?>" class="lsvr_project-list-widget__item-title-link">
											<?php echo esc_html( $project_post->post_title ); ?>
										</a>
									</h4>

									<?php // Date
									if ( true === $show_date ) : ?>

										<p class="lsvr_project-list-widget__item-date">
											<time datetime="<?php echo esc_attr( get_the_time( 'c', $project_post->ID ) ); ?>">
												<?php echo esc_html( date_i18n( get_option( 'date_format' ), strtotime( $project_post->post_date ) ) ); ?>
											</time>
										</p>

									<?php endif; ?>

									<?php // Category
									$terms = wp_get_post_terms( $project_post->ID, 'lsvr_project_cat' );
									$category_html = '';
									if ( ! empty( $terms ) ) {
										foreach ( $terms as $term ) {
											$category_html .= '<a href="' . esc_url( get_term_link( $term->term_id, 'lsvr_project_cat' ) ) . '" class="lsvr_project-list-widget__item-category-link">' . $term->name . '</a>';
											$category_html .= $term !== end( $terms ) ? ', ' : '';
										}
									}
									if ( true === $show_category && ! empty( $category_html ) ) : ?>

										<p class="lsvr_project-list-widget__item-category">
											<?php echo sprintf( esc_html__( 'in %s', 'lsvr-portfolio' ), $category_html ); ?>
										</p>

									<?php endif; ?>

								</div>

							</div>
	        			</li>

	        		<?php endforeach; ?>
        		</ul>

				<?php if ( ! empty( $instance[ 'more_label' ] ) ) : ?>

					<p class="widget__more">

						<?php if ( ! empty( $instance['category'] ) && is_numeric( $instance['category'] ) ) : ?>

							<a href="<?php echo esc_url( get_term_link( (int) $instance['category'], 'lsvr_project_cat' ) ); ?>" class="widget__more-link"><?php echo esc_html( $instance[ 'more_label' ] ); ?></a>

						<?php else : ?>

							<a href="<?php echo esc_url( get_post_type_archive_link( 'lsvr_project' ) ); ?>" class="widget__more-link"><?php echo esc_html( $instance[ 'more_label' ] ); ?></a>

						<?php endif; ?>
					</p>

				<?php endif; ?>

        	<?php else : ?>

        		<p class="widget__no-results"><?php esc_html_e( 'There are no projects', 'lsvr-portfolio' ); ?></p>

        	<?php endif; ?>

        </div>

        <?php // After widget content
        parent::after_widget_content( $args, $instance ); ?>

        <?php

    }

}}

?>