<?php
/**
 * Plugin Name: LSVR Portfolio
 * Description: Adds Project custom post type
 * Version: 1.2.0
 * Author: LSVRthemes
 * Author URI: http://themeforest.net/user/LSVRthemes/portfolio
 * Text Domain: lsvr-portfolio
 * Domain Path: /languages
 * License: http://themeforest.net/licenses
 * License URI: http://themeforest.net/licenses
*/

// Include additional functions and classes
require_once( 'inc/classes/lsvr-cpt.php' );
require_once( 'inc/classes/lsvr-cpt-project.php' );
require_once( 'inc/classes/lsvr-permalink-settings.php' );
require_once( 'inc/classes/lsvr-permalink-settings-portfolio.php' );
require_once( 'inc/core-functions.php' );
require_once( 'inc/blocks-config.php' );

// Load textdomain
load_plugin_textdomain( 'lsvr-portfolio', false, plugin_basename( dirname( __FILE__ ) ) . '/languages/' );

// Register Project CPT
if ( class_exists( 'Lsvr_CPT_Project' ) ) {

	// Register CPT on plugin activation
	if ( ! function_exists( 'lsvr_portfolio_activate_register_project_cpt' ) ) {
		function lsvr_portfolio_activate_register_project_cpt() {
			$lsvr_project_cpt = new Lsvr_CPT_Project();
			$lsvr_project_cpt->activate_cpt();
		}
	}
	register_activation_hook( __FILE__, 'lsvr_portfolio_activate_register_project_cpt' );

	// Register CPT
	$lsvr_project_cpt = new Lsvr_CPT_Project();

}

// Add permalink settings
if ( class_exists( 'Lsvr_Permalink_Settings_Portfolio' ) ) {
	$permalink_settings = new Lsvr_Permalink_Settings_Portfolio();
}

// Register widgets
add_action( 'widgets_init', 'lsvr_portfolio_register_widgets' );
if ( ! function_exists( 'lsvr_portfolio_register_widgets' ) ) {
	function lsvr_portfolio_register_widgets() {

		// Project list
		require_once( 'inc/classes/widgets/lsvr-widget-project-list.php' );
		if ( class_exists( 'Lsvr_Widget_Project_List' ) ) {
			register_widget( 'Lsvr_Widget_Project_List' );
		}

		// Featured project
		require_once( 'inc/classes/widgets/lsvr-widget-project-featured.php' );
		if ( class_exists( 'Lsvr_Widget_Project_Featured' ) ) {
			register_widget( 'Lsvr_Widget_Project_Featured' );
		}

		// Project categories
		require_once( 'inc/classes/widgets/lsvr-widget-project-categories.php' );
		if ( class_exists( 'Lsvr_Widget_Project_Categories' ) ) {
			register_widget( 'Lsvr_Widget_Project_Categories' );
		}

	}
}

// Register shortcodes
add_action( 'init', 'lsvr_portfolio_register_shortcodes' );
if ( ! function_exists( 'lsvr_portfolio_register_shortcodes' ) ) {
	function lsvr_portfolio_register_shortcodes() {

    	// Project List Widget
		require_once( 'inc/classes/shortcodes/lsvr-shortcode-project-list-widget.php' );
		if ( class_exists( 'Lsvr_Shortcode_Project_List_Widget' ) ) {
			add_shortcode( 'lsvr_project_list_widget', array( 'Lsvr_Shortcode_Project_List_Widget', 'shortcode' ) );
		}

    	// Featured Project Widget
		require_once( 'inc/classes/shortcodes/lsvr-shortcode-project-featured-widget.php' );
		if ( class_exists( 'Lsvr_Shortcode_Project_Featured_Widget' ) ) {
			add_shortcode( 'lsvr_project_featured_widget', array( 'Lsvr_Shortcode_Project_Featured_Widget', 'shortcode' ) );
		}

	}
}

?>