<?php

// Register custom category
add_filter( 'block_categories', 'lsvr_bluecollar_toolkit_register_blocks_category' );
if ( ! function_exists( 'lsvr_bluecollar_toolkit_register_blocks_category' ) ) {
	function lsvr_bluecollar_toolkit_register_blocks_category( $categories ) {

	    return array_merge( $categories, array(
	        array(
	            'slug' => 'lsvr-bluecollar-toolkit',
	            'title' => esc_html__( 'BlueCollar', 'lsvr-bluecollar-toolkit' ),
	        ),
	    ));

	}
}

// Register blocks
add_action( 'init', 'lsvr_bluecollar_toolkit_register_blocks', 20 );
if ( ! function_exists( 'lsvr_bluecollar_toolkit_register_blocks' ) ) {
	function lsvr_bluecollar_toolkit_register_blocks() {

		if ( function_exists( 'register_block_type' ) && function_exists( 'lsvr_framework_register_shortcode_block' ) ) {

    		// CTA
			if ( class_exists( 'Lsvr_Shortcode_Bluecollar_CTA' ) ) {
				lsvr_framework_register_shortcode_block( 'lsvr-bluecollar-toolkit/cta', array(
					'attributes' => Lsvr_Shortcode_Bluecollar_CTA::lsvr_shortcode_atts(),
					'render_callback' => array( 'Lsvr_Shortcode_Bluecollar_CTA', 'shortcode' ),
				));
			}

    		// FAQ
			if ( class_exists( 'Lsvr_Shortcode_Bluecollar_FAQ' ) ) {
				lsvr_framework_register_shortcode_block( 'lsvr-bluecollar-toolkit/faq', array(
					'attributes' => Lsvr_Shortcode_Bluecollar_FAQ::lsvr_shortcode_atts(),
					'render_callback' => array( 'Lsvr_Shortcode_Bluecollar_FAQ', 'shortcode' ),
				));
			}

    		// Features
			if ( class_exists( 'Lsvr_Shortcode_Bluecollar_Features' ) ) {
				lsvr_framework_register_shortcode_block( 'lsvr-bluecollar-toolkit/features', array(
					'attributes' => Lsvr_Shortcode_Bluecollar_Features::lsvr_shortcode_atts(),
					'render_callback' => array( 'Lsvr_Shortcode_Bluecollar_Features', 'shortcode' ),
				));
			}

    		// Intro
			if ( class_exists( 'Lsvr_Shortcode_Bluecollar_Intro' ) ) {
				lsvr_framework_register_shortcode_block( 'lsvr-bluecollar-toolkit/intro', array(
					'attributes' => Lsvr_Shortcode_Bluecollar_Intro::lsvr_shortcode_atts(),
					'render_callback' => array( 'Lsvr_Shortcode_Bluecollar_Intro', 'shortcode' ),
				));
			}

    		// Posts
			if ( class_exists( 'Lsvr_Shortcode_Bluecollar_Posts' ) ) {
				lsvr_framework_register_shortcode_block( 'lsvr-bluecollar-toolkit/posts', array(
					'attributes' => Lsvr_Shortcode_Bluecollar_Posts::lsvr_shortcode_atts(),
					'render_callback' => array( 'Lsvr_Shortcode_Bluecollar_Posts', 'shortcode' ),
				));
			}

    		// Projects
			if ( class_exists( 'Lsvr_Shortcode_Bluecollar_Projects' ) ) {
				lsvr_framework_register_shortcode_block( 'lsvr-bluecollar-toolkit/projects', array(
					'attributes' => Lsvr_Shortcode_Bluecollar_Projects::lsvr_shortcode_atts(),
					'render_callback' => array( 'Lsvr_Shortcode_Bluecollar_Projects', 'shortcode' ),
				));
			}

    		// Services
			if ( class_exists( 'Lsvr_Shortcode_Bluecollar_Services' ) ) {
				lsvr_framework_register_shortcode_block( 'lsvr-bluecollar-toolkit/services', array(
					'attributes' => Lsvr_Shortcode_Bluecollar_Services::lsvr_shortcode_atts(),
					'render_callback' => array( 'Lsvr_Shortcode_Bluecollar_Services', 'shortcode' ),
				));
			}

    		// Sidebar
			if ( class_exists( 'Lsvr_Shortcode_Bluecollar_Sidebar' ) ) {
				lsvr_framework_register_shortcode_block( 'lsvr-bluecollar-toolkit/sidebar', array(
					'attributes' => Lsvr_Shortcode_Bluecollar_Sidebar::lsvr_shortcode_atts(),
					'render_callback' => array( 'Lsvr_Shortcode_Bluecollar_Sidebar', 'shortcode' ),
				));
			}

    		// Testimonials
			if ( class_exists( 'Lsvr_Shortcode_Bluecollar_Testimonials' ) ) {
				lsvr_framework_register_shortcode_block( 'lsvr-bluecollar-toolkit/testimonials', array(
					'attributes' => Lsvr_Shortcode_Bluecollar_Testimonials::lsvr_shortcode_atts(),
					'render_callback' => array( 'Lsvr_Shortcode_Bluecollar_Testimonials', 'shortcode' ),
				));
			}

		}

	}
}

// Register blocks JSON
add_filter( 'lsvr_framework_register_shortcode_blocks_json', 'lsvr_bluecollar_toolkit_register_blocks_json' );
if ( ! function_exists( 'lsvr_bluecollar_toolkit_register_blocks_json' ) ) {
	function lsvr_bluecollar_toolkit_register_blocks_json( $data = array() ) {

		$data = empty( $data ) ? array() : $data;

		if ( function_exists( 'register_block_type' ) && function_exists( 'lsvr_framework_register_shortcode_block_json' ) ) {

			// CTA
			if ( class_exists( 'Lsvr_Shortcode_Bluecollar_CTA' ) ) {
				array_push( $data, lsvr_framework_register_shortcode_block_json( array(
					'name' => 'lsvr-bluecollar-toolkit/cta',
					'tag' => 'lsvr_bluecollar_cta',
					'title' => esc_html__( 'BlueCollar CTA', 'lsvr-bluecollar-toolkit' ),
		        	'description' => esc_html__( 'Block with title, text and button', 'lsvr-bluecollar-toolkit' ),
		        	'category' => 'lsvr-bluecollar-toolkit',
		        	'icon' => 'align-center',
		        	'panel_title' => esc_html__( 'Settings', 'lsvr-bluecollar-toolkit' ),
		        	'attributes' => Lsvr_Shortcode_Bluecollar_CTA::lsvr_shortcode_atts(),
				)));
			}

			// FAQ
			if ( class_exists( 'Lsvr_Shortcode_Bluecollar_FAQ' ) ) {
				array_push( $data, lsvr_framework_register_shortcode_block_json( array(
					'name' => 'lsvr-bluecollar-toolkit/faq',
					'tag' => 'lsvr_bluecollar_faq',
					'title' => esc_html__( 'BlueCollar FAQ', 'lsvr-bluecollar-toolkit' ),
		        	'description' => esc_html__( 'List of FAQ posts', 'lsvr-bluecollar-toolkit' ),
		        	'category' => 'lsvr-bluecollar-toolkit',
		        	'icon' => 'lightbulb',
		        	'panel_title' => esc_html__( 'Settings', 'lsvr-bluecollar-toolkit' ),
		        	'attributes' => Lsvr_Shortcode_Bluecollar_FAQ::lsvr_shortcode_atts(),
				)));
			}

			// Features
			if ( class_exists( 'Lsvr_Shortcode_Bluecollar_Features' ) ) {
				array_push( $data, lsvr_framework_register_shortcode_block_json( array(
					'name' => 'lsvr-bluecollar-toolkit/features',
					'tag' => 'lsvr_bluecollar_features',
					'title' => esc_html__( 'BlueCollar Features', 'lsvr-bluecollar-toolkit' ),
		        	'description' => esc_html__( 'Blocks with icon, title and text', 'lsvr-bluecollar-toolkit' ),
		        	'category' => 'lsvr-bluecollar-toolkit',
		        	'icon' => 'star-filled',
		        	'panel_title' => esc_html__( 'Settings', 'lsvr-bluecollar-toolkit' ),
		        	'attributes' => Lsvr_Shortcode_Bluecollar_Features::lsvr_shortcode_atts(),
				)));
			}

			// Intro
			if ( class_exists( 'Lsvr_Shortcode_Bluecollar_Intro' ) ) {
				array_push( $data, lsvr_framework_register_shortcode_block_json( array(
					'name' => 'lsvr-bluecollar-toolkit/intro',
					'tag' => 'lsvr_bluecollar_intro',
					'title' => esc_html__( 'BlueCollar Intro', 'lsvr-bluecollar-toolkit' ),
		        	'description' => esc_html__( 'Section with image and text', 'lsvr-bluecollar-toolkit' ),
		        	'category' => 'lsvr-bluecollar-toolkit',
		        	'icon' => 'id',
		        	'panel_title' => esc_html__( 'Settings', 'lsvr-bluecollar-toolkit' ),
		        	'attributes' => Lsvr_Shortcode_Bluecollar_Intro::lsvr_shortcode_atts(),
				)));
			}

			// Posts
			if ( class_exists( 'Lsvr_Shortcode_Bluecollar_Posts' ) ) {
				array_push( $data, lsvr_framework_register_shortcode_block_json( array(
					'name' => 'lsvr-bluecollar-toolkit/posts',
					'tag' => 'lsvr_bluecollar_posts',
					'title' => esc_html__( 'BlueCollar Posts', 'lsvr-bluecollar-toolkit' ),
		        	'description' => esc_html__( 'List of posts', 'lsvr-bluecollar-toolkit' ),
		        	'category' => 'lsvr-bluecollar-toolkit',
		        	'icon' => 'admin-post',
		        	'panel_title' => esc_html__( 'Settings', 'lsvr-bluecollar-toolkit' ),
		        	'attributes' => Lsvr_Shortcode_Bluecollar_Posts::lsvr_shortcode_atts(),
				)));
			}

			// Projects
			if ( class_exists( 'Lsvr_Shortcode_Bluecollar_Projects' ) ) {
				array_push( $data, lsvr_framework_register_shortcode_block_json( array(
					'name' => 'lsvr-bluecollar-toolkit/projects',
					'tag' => 'lsvr_bluecollar_projects',
					'title' => esc_html__( 'BlueCollar Portfolio', 'lsvr-bluecollar-toolkit' ),
		        	'description' => esc_html__( 'List of portfolio projects', 'lsvr-bluecollar-toolkit' ),
		        	'category' => 'lsvr-bluecollar-toolkit',
		        	'icon' => 'portfolio',
		        	'panel_title' => esc_html__( 'Settings', 'lsvr-bluecollar-toolkit' ),
		        	'attributes' => Lsvr_Shortcode_Bluecollar_Projects::lsvr_shortcode_atts(),
				)));
			}

			// Services
			if ( class_exists( 'Lsvr_Shortcode_Bluecollar_Services' ) ) {
				array_push( $data, lsvr_framework_register_shortcode_block_json( array(
					'name' => 'lsvr-bluecollar-toolkit/services',
					'tag' => 'lsvr_bluecollar_services',
					'title' => esc_html__( 'BlueCollar Services', 'lsvr-bluecollar-toolkit' ),
		        	'description' => esc_html__( 'List of services', 'lsvr-bluecollar-toolkit' ),
		        	'category' => 'lsvr-bluecollar-toolkit',
		        	'icon' => 'businessman',
		        	'panel_title' => esc_html__( 'Settings', 'lsvr-bluecollar-toolkit' ),
		        	'attributes' => Lsvr_Shortcode_Bluecollar_Services::lsvr_shortcode_atts(),
				)));
			}

			// Sidebar
			if ( class_exists( 'Lsvr_Shortcode_Bluecollar_Sidebar' ) ) {
				array_push( $data, lsvr_framework_register_shortcode_block_json( array(
					'name' => 'lsvr-bluecollar-toolkit/sidebar',
					'tag' => 'lsvr_bluecollar_sidebar',
					'title' => esc_html__( 'BlueCollar Sidebar', 'lsvr-bluecollar-toolkit' ),
		        	'description' => esc_html__( 'Sidebar with widgets', 'lsvr-bluecollar-toolkit' ),
		        	'category' => 'lsvr-bluecollar-toolkit',
		        	'icon' => 'screenoptions',
		        	'panel_title' => esc_html__( 'Settings', 'lsvr-bluecollar-toolkit' ),
		        	'attributes' => Lsvr_Shortcode_Bluecollar_Sidebar::lsvr_shortcode_atts(),
				)));
			}

			// Testimonials
			if ( class_exists( 'Lsvr_Shortcode_Bluecollar_Testimonials' ) ) {
				array_push( $data, lsvr_framework_register_shortcode_block_json( array(
					'name' => 'lsvr-bluecollar-toolkit/testimonials',
					'tag' => 'lsvr_bluecollar_testimonials',
					'title' => esc_html__( 'BlueCollar Testimonials', 'lsvr-bluecollar-toolkit' ),
		        	'description' => esc_html__( 'List of testimonials', 'lsvr-bluecollar-toolkit' ),
		        	'category' => 'lsvr-bluecollar-toolkit',
		        	'icon' => 'thumbs-up',
		        	'panel_title' => esc_html__( 'Settings', 'lsvr-bluecollar-toolkit' ),
		        	'attributes' => Lsvr_Shortcode_Bluecollar_Testimonials::lsvr_shortcode_atts(),
				)));
			}

		}

		return $data;

	}
}

?>