<?php
/**
 * LSVR BlueCollar CTA Shortcode
 */
if ( ! class_exists( 'Lsvr_Shortcode_Bluecollar_CTA' ) ) {
    class Lsvr_Shortcode_Bluecollar_CTA {

        public static function shortcode( $atts = array(), $content = null, $tag = '' ) {

            // Merge default atts and received atts
            $args = shortcode_atts(
                array(
                    'title' => '',
                    'text' => '',
                    'background_image' => '',
                    'colored_background' => '',
                    'more_label' => '',
                    'more_link' => '',
                    'more_link_new_window' => false,
                    'id' => '',
                    'className' => '',
                    'editor_view' => false,
                ),
                $atts
            );

            // Check if editor view
            $editor_view = true === $args['editor_view'] || '1' === $args['editor_view'] || 'true' === $args['editor_view'] ? true : false;

            // Enable colored background
            $colored_background = true === $args['colored_background'] || '1' === $args['colored_background'] || 'true' === $args['colored_background'] ? true : false;

            // More link new window
            $more_link_new_window = true === $args['more_link_new_window'] || '1' === $args['more_link_new_window'] || 'true' === $args['more_link_new_window'] ? true : false;

            // Background image
            if ( ( ! empty( $args['background_image'] ) && is_numeric( $args['background_image'] ) && (int) $args['background_image'] > 0 )
                || ( is_array( $args['background_image'] ) && ! empty( $args['background_image']['id'] ) ) ) {

                $image_id = is_array( $args['background_image'] ) && ! empty( $args['background_image']['id'] ) ? (int) $args['background_image']['id'] : (int) $args['background_image'];
                $image_data = wp_get_attachment_image_src( $image_id, 'full' );
                if ( ! empty( $image_data[0] ) ) {
                    $background_url = $image_data[0];
                }

            } elseif ( ! empty( $args['background_image'] ) && ! is_array( $args['background_image'] ) ) {
                $background_url = $args['background_image'];
            }

            // Get class
            $class_arr = array( 'lsvr-bluecollar-cta' );
            if ( true === $editor_view ) {
                array_push( $class_arr, 'lsvr-bluecollar-cta--editor-view' );
            }
            if ( true === $colored_background ) {
                array_push( $class_arr, 'lsvr-bluecollar-cta--has-background-color' );
            }
            if ( ! empty( $background_url ) ) {
                array_push( $class_arr, 'lsvr-bluecollar-cta--has-background-image' );
            }
            if ( ! empty( $args['more_label'] ) && ! empty( $args['more_link'] ) ) {
                array_push( $class_arr, 'lsvr-bluecollar-cta--has-button' );
            }
            if ( ! empty( $args['className'] ) ) {
                array_push( $class_arr, $args['className'] );
            }

            ob_start(); ?>

            <!-- BLUECOLLAR CTA : begin -->
            <div class="<?php echo esc_attr( implode( ' ', $class_arr ) ); ?>"
                <?php echo ! empty( $args['id'] ) ? ' id="' . esc_attr( $args['id'] ) . '"' : ''; ?>>
                <div class="lsvr-bluecollar-cta__bg"
                    <?php if ( ! empty( $background_url ) ) { echo ' style="background-image: url( \'' . esc_url( $background_url ) . '\');"'; } ?>>
                    <div class="lsvr-bluecollar-cta__inner">
                        <div class="lsvr-container">
                            <div class="lsvr-bluecollar-cta__content">

                                <?php if ( ! empty( $args['title'] ) ) : ?>

                                    <h3 class="lsvr-bluecollar-cta__title">

                                        <?php echo wp_kses( $args['title'], array(
                                            'a' => array(
                                                'href' => '',
                                            ),
                                            'br' => array(),
                                            'span' => array(
                                                'class' => array(),
                                                'style' => array(),
                                            ),
                                            'strong' => array(),
                                        )); ?>

                                    </h3>

                                <?php endif; ?>

                                <?php if ( ! empty( $args['text'] ) ) : ?>

                                    <div class="lsvr-bluecollar-cta__text">

                                        <?php echo wpautop( wp_kses( $args['text'], array(
                                            'a' => array(
                                                'href' => array(),
                                                'target' => array(),
                                            ),
                                            'br' => array(),
                                            'strong' => array(),
                                        ))); ?>

                                    </div>

                                <?php endif; ?>

                               <?php if ( ! empty( $args['more_label'] ) && ! empty( $args['more_link'] ) ) : ?>

                                    <p class="lsvr-bluecollar-cta__button">
                                        <a href="<?php echo esc_url( $args['more_link'] ); ?>" class="lsvr-bluecollar-cta__button-link"
                                            <?php if ( true === $more_link_new_window ) { echo ' target="_blank"'; } ?>>
                                            <?php echo esc_html( $args['more_label'] ); ?>
                                        </a>
                                    </p>

                                <?php endif; ?>

                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <!-- BLUECOLLAR CTA : end -->

            <?php return ob_get_clean();

        }

        // Shortcode params
        public static function lsvr_shortcode_atts() {
            return array_merge( array(

                // Title
                array(
                    'name' => 'title',
                    'type' => 'text',
                    'label' => esc_html__( 'Title', 'lsvr-bluecollar-toolkit' ),
                    'default' => esc_html__( 'CTA', 'lsvr-bluecollar-toolkit' ),
                    'priority' => 10,
                ),

                // Text
                array(
                    'name' => 'text',
                    'type' => 'textarea',
                    'label' => esc_html__( 'Text', 'lsvr-bluecollar-toolkit' ),
                    'default' => esc_html__( 'Lorem ipsum dolor sit amet, consectetuer adipiscing elit.', 'lsvr-bluecollar-toolkit' ),
                    'priority' => 20,
                ),

                // Background image
                array(
                    'name' => 'background_image',
                    'type' => 'image',
                    'label' => esc_html__( 'Background Image', 'lsvr-bluecollar-toolkit' ),
                    'description' => esc_html__( 'Background image of this section.', 'lsvr-bluecollar-toolkit' ),
                    'priority' => 30,
                ),

                // Colored background
                array(
                    'name' => 'colored_background',
                    'type' => 'checkbox',
                    'label' => esc_html__( 'Display Colored Background', 'lsvr-bluecollar-toolkit' ),
                    'description' => esc_html__( 'Make this section stand out. If you are using background image, it will use color overlay.', 'lsvr-bluecollar-toolkit' ),
                    'priority' => 40,
                ),

                // More label
                array(
                    'name' => 'more_label',
                    'type' => 'text',
                    'label' => esc_html__( 'More Button Label', 'lsvr-bluecollar-toolkit' ),
                    'default' => esc_html__( 'Learn more', 'lsvr-bluecollar-toolkit' ),
                    'priority' => 50,
                ),

                // More link
                array(
                    'name' => 'more_link',
                    'type' => 'text',
                    'label' => esc_html__( 'More Button Link', 'lsvr-bluecollar-toolkit' ),
                    'default' => esc_html__( 'http://www.example.org', 'lsvr-bluecollar-toolkit' ),
                    'priority' => 60,
                ),

                // More link open in new window
                array(
                    'name' => 'more_link_new_window',
                    'type' => 'checkbox',
                    'label' => esc_html__( 'Open Button Link In a New Window', 'lsvr-bluecollar-toolkit' ),
                    'priority' => 70,
                ),

                // ID
                array(
                    'name' => 'id',
                    'type' => 'text',
                    'label' => esc_html__( 'Unique ID', 'lsvr-bluecollar-toolkit' ),
                    'priority' => 100,
                ),

            ), apply_filters( 'lsvr_bluecollar_cta_shortcode_atts', array() ) );
        }

    }
}
?>