<?php
/**
 * LSVR BlueCollar Features Shortcode
 */
if ( ! class_exists( 'Lsvr_Shortcode_Bluecollar_Features' ) ) {
    class Lsvr_Shortcode_Bluecollar_Features {

        public static function shortcode( $atts = array(), $content = null, $tag = '' ) {

            // Merge default atts and received atts
            $args = shortcode_atts(
                array(
                    'feature1_title' => '',
                    'feature1_title_link' => '',
                    'feature1_icon' => '',
                    'feature1_text' => '',
                    'feature1_more_label' => '',
                    'feature1_more_link' => '',
                    'feature2_title' => '',
                    'feature2_title_link' => '',
                    'feature2_icon' => '',
                    'feature2_text' => '',
                    'feature2_more_label' => '',
                    'feature2_more_link' => '',
                    'feature3_title' => '',
                    'feature3_title_link' => '',
                    'feature3_icon' => '',
                    'feature3_text' => '',
                    'feature3_more_label' => '',
                    'feature3_more_link' => '',
                    'show_top_border' => '',
                    'push_top' => '',
                    'id' => '',
                    'className' => '',
                    'editor_view' => false,
                ),
                $atts
            );

            // Parse fetures
            $features = array();
            for ( $i = 1; $i <= 3; $i++ ) {
                if ( ! empty( $args['feature' . $i . '_title'] ) || ! empty( $args['feature' . $i . '_text'] ) ) {
                    $feature = array();
                    $feature['title'] = ! empty( $args['feature' . $i . '_title'] ) ? $args['feature' . $i . '_title'] : '';
                    $feature['title_link'] = ! empty( $args['feature' . $i . '_title_link'] ) ? $args['feature' . $i . '_title_link'] : '';
                    $feature['icon'] = ! empty( $args['feature' . $i . '_icon'] ) ? $args['feature' . $i . '_icon'] : '';
                    $feature['text'] = ! empty( $args['feature' . $i . '_text'] ) ? $args['feature' . $i . '_text'] : '';
                    $feature['more_label'] = ! empty( $args['feature' . $i . '_more_label'] ) ? $args['feature' . $i . '_more_label'] : '';
                    $feature['more_link'] = ! empty( $args['feature' . $i . '_more_link'] ) ? $args['feature' . $i . '_more_link'] : '';
                    array_push( $features, $feature );
                }
            }

            // Prepare grid and cols classes
            $columns = count( $features );
            if ( $columns > 1 ) {
                $grid_class = 'lsvr-grid lsvr-grid--' . $columns . '-cols';
                $grid_class .= $columns > 1 ? ' lsvr-grid--md-2-cols' : '';
                $col_class = 'lsvr-grid__col lsvr-grid__col--span-' . esc_attr( 12 / $columns );
                $col_class .= $columns > 1 ? ' lsvr-grid__col--md-span-6' : '';
            }

            // Check if editor view
            $editor_view = true === $args['editor_view'] || '1' === $args['editor_view'] || 'true' === $args['editor_view'] ? true : false;

            // Show top border
            $show_top_border = true === $args['show_top_border'] || '1' === $args['show_top_border'] || 'true' === $args['show_top_border'] ? true : false;

            // Push top
            $push_top = true === $args['push_top'] || '1' === $args['push_top'] || 'true' === $args['push_top'] ? true : false;

            // Element class
            $class_arr = array( 'lsvr-bluecollar-features' );
            if ( true === $editor_view ) {
                array_push( $class_arr, 'lsvr-bluecollar-features--editor-view' );
            }
            if ( ! empty( $features ) ) {
                array_push( $class_arr, 'lsvr-bluecollar-features--' . count( $features ) . '-items' );
            }
            if ( true === $show_top_border ) {
                array_push( $class_arr, 'lsvr-bluecollar-features--has-top-border' );
            }
            if ( true === $push_top ) {
                array_push( $class_arr, 'lsvr-bluecollar-features--push-top' );
            }
            if ( ! empty( $args['className'] ) ) {
                array_push( $class_arr, $args['className'] );
            }

            ob_start(); ?>

            <!-- BLUECOLLAR FEATURES : begin -->
            <section class="<?php echo esc_attr( implode( ' ', $class_arr ) ); ?>"
                <?php echo ! empty( $args['id'] ) ? ' id="' . esc_attr( $args['id'] ) . '"' : ''; ?>>
                <div class="lsvr-bluecollar-features__bg">
                    <div class="lsvr-container">
                        <div class="lsvr-bluecollar-features__inner">

                            <div class="lsvr-bluecollar-features__wrapper">

                                <?php if ( ! empty( $features ) ) : ?>

                                    <?php if ( $columns > 1 ) : ?>
                                        <div class="<?php echo esc_attr( $grid_class ); ?> lsvr-bluecollar-features__grid">
                                    <?php endif; ?>

                                    <?php foreach ( $features as $feature ) : ?>

                                            <?php if ( $columns > 1 ) : ?>
                                                <div class="<?php echo esc_attr( $col_class ); ?> lsvr-bluecollar-features__grid-col">
                                            <?php endif; ?>

                                            <div class="lsvr-bluecollar-features__item<?php if ( ! empty( $feature['icon'] ) ) { echo ' lsvr-bluecollar-features__item--has-icon'; } ?>">

                                                <?php if ( ! empty( $feature['icon'] ) ) : ?>
                                                    <i class="lsvr-bluecollar-features__item-icon <?php echo esc_attr( $feature['icon'] ); ?>"></i>
                                                <?php endif; ?>

                                                <?php if ( ! empty( $feature['title'] ) ) : ?>

                                                    <?php if ( ! empty( $feature['title_link'] ) ) : ?>

                                                        <h3 class="lsvr-bluecollar-features__item-title">
                                                            <a href="<?php echo esc_url( $feature['title_link'] ); ?>"
                                                                class="lsvr-bluecollar-features__item-title-link"><?php echo esc_html( $feature['title'] ); ?></a>
                                                        </h3>

                                                    <?php else : ?>

                                                        <h3 class="lsvr-bluecollar-features__item-title">
                                                            <?php echo esc_html( $feature['title'] ); ?>
                                                        </h3>

                                                    <?php endif; ?>

                                                <?php endif; ?>

                                                <?php if ( ! empty( $feature['text'] ) ) : ?>

                                                    <div class="lsvr-bluecollar-features__item-text">
                                                        <?php echo wpautop( wp_kses( $feature['text'], array(
                                                            'a' => array(
                                                                'href' => '',
                                                            ),
                                                            'strong' => array(),
                                                        ) ) ); ?>
                                                    </div>

                                                <?php endif; ?>

                                                <?php if ( ! empty( $feature['more_label'] ) && ! empty( $feature['more_link'] ) ) : ?>

                                                    <p class="lsvr-bluecollar-features__item-more">
                                                        <a href="<?php echo esc_url( $feature['more_link'] ); ?>"
                                                            class="lsvr-bluecollar-features__item-more-link">
                                                            <?php echo esc_html( $feature['more_label'] ); ?>
                                                        </a>
                                                    </p>

                                                <?php endif; ?>

                                            </div>

                                            <?php if ( $columns > 1 ) : ?>
                                                </div>
                                            <?php endif; ?>

                                    <?php endforeach; ?>

                                    <?php if ( $columns > 1 ) : ?>
                                        </div>
                                    <?php endif; ?>

                                <?php endif; ?>

                            </div>

                        </div>
                    </div>
                </div>
            </section>
            <!-- BLUECOLLAR FEATURES : end -->

            <?php return ob_get_clean();

        }

        // Shortcode params
        public static function lsvr_shortcode_atts() {
            return array_merge( array(

                // Feature 1 Title
                array(
                    'name' => 'feature1_title',
                    'type' => 'text',
                    'label' => esc_html__( 'Feature 1 Title', 'lsvr-bluecollar-toolkit' ),
                    'default' => esc_html__( 'Feature 1', 'lsvr-bluecollar-toolkit' ),
                    'priority' => 110,
                ),

                // Feature 1 Title Link
                array(
                    'name' => 'feature1_title_link',
                    'type' => 'text',
                    'label' => esc_html__( 'Feature 1 Title Link', 'lsvr-bluecollar-toolkit' ),
                    'priority' => 120,
                ),

                // Feature 1 Icon
                array(
                    'name' => 'feature1_icon',
                    'type' => 'text',
                    'label' => esc_html__( 'Feature 1 Icon', 'lsvr-bluecollar-toolkit' ),
                    'priority' => 130,
                ),

                // Feature 1 Text
                array(
                    'name' => 'feature1_text',
                    'type' => 'textarea',
                    'label' => esc_html__( 'Feature 1 Text', 'lsvr-bluecollar-toolkit' ),
                    'default' => esc_html__( 'Lorem ipsum dolor sit amet, consectetuer adipiscing elit.', 'lsvr-bluecollar-toolkit' ),
                    'priority' => 140,
                ),

                // Feature 1 More Label
                array(
                    'name' => 'feature1_more_label',
                    'type' => 'text',
                    'label' => esc_html__( 'Feature 1 More Button Label', 'lsvr-bluecollar-toolkit' ),
                    'default' => esc_html__( 'Learn More', 'lsvr-bluecollar-toolkit' ),
                    'priority' => 150,
                ),

                // Feature 1 More Link
                array(
                    'name' => 'feature1_more_link',
                    'type' => 'text',
                    'label' => esc_html__( 'Feature 1 More Button Link', 'lsvr-bluecollar-toolkit' ),
                    'default' => esc_html__( '#', 'lsvr-bluecollar-toolkit' ),
                    'priority' => 160,
                ),

                // Feature 2 Title
                array(
                    'name' => 'feature2_title',
                    'type' => 'text',
                    'label' => esc_html__( 'Feature 2 Title', 'lsvr-bluecollar-toolkit' ),
                    'default' => esc_html__( 'Feature 2', 'lsvr-bluecollar-toolkit' ),
                    'priority' => 210,
                ),

                // Feature 2 Title Link
                array(
                    'name' => 'feature2_title_link',
                    'type' => 'text',
                    'label' => esc_html__( 'Feature 2 Title Link', 'lsvr-bluecollar-toolkit' ),
                    'priority' => 220,
                ),

                // Feature 2 Icon
                array(
                    'name' => 'feature2_icon',
                    'type' => 'text',
                    'label' => esc_html__( 'Feature 2 Icon', 'lsvr-bluecollar-toolkit' ),
                    'priority' => 230,
                ),

                // Feature 2 Text
                array(
                    'name' => 'feature2_text',
                    'type' => 'textarea',
                    'label' => esc_html__( 'Feature 2 Text', 'lsvr-bluecollar-toolkit' ),
                    'default' => esc_html__( 'Lorem ipsum dolor sit amet, consectetuer adipiscing elit.', 'lsvr-bluecollar-toolkit' ),
                    'priority' => 240,
                ),

                // Feature 2 More Label
                array(
                    'name' => 'feature2_more_label',
                    'type' => 'text',
                    'label' => esc_html__( 'Feature 2 More Button Label', 'lsvr-bluecollar-toolkit' ),
                    'default' => esc_html__( 'Learn More', 'lsvr-bluecollar-toolkit' ),
                    'priority' => 250,
                ),

                // Feature 2 More Link
                array(
                    'name' => 'feature2_more_link',
                    'type' => 'text',
                    'label' => esc_html__( 'Feature 2 More Button Link', 'lsvr-bluecollar-toolkit' ),
                    'default' => esc_html__( '#', 'lsvr-bluecollar-toolkit' ),
                    'priority' => 260,
                ),

                // Feature 3 Title
                array(
                    'name' => 'feature3_title',
                    'type' => 'text',
                    'label' => esc_html__( 'Feature 3 Title', 'lsvr-bluecollar-toolkit' ),
                    'default' => esc_html__( 'Feature 3', 'lsvr-bluecollar-toolkit' ),
                    'priority' => 310,
                ),

                // Feature 3 Title Link
                array(
                    'name' => 'feature3_title_link',
                    'type' => 'text',
                    'label' => esc_html__( 'Feature 3 Title Link', 'lsvr-bluecollar-toolkit' ),
                    'priority' => 320,
                ),

                // Feature 3 Icon
                array(
                    'name' => 'feature3_icon',
                    'type' => 'text',
                    'label' => esc_html__( 'Feature 3 Icon', 'lsvr-bluecollar-toolkit' ),
                    'priority' => 330,
                ),

                // Feature 3 Text
                array(
                    'name' => 'feature3_text',
                    'type' => 'textarea',
                    'label' => esc_html__( 'Feature 3 Text', 'lsvr-bluecollar-toolkit' ),
                    'default' => esc_html__( 'Lorem ipsum dolor sit amet, consectetuer adipiscing elit.', 'lsvr-bluecollar-toolkit' ),
                    'priority' => 340,
                ),

                // Feature 3 More Label
                array(
                    'name' => 'feature3_more_label',
                    'type' => 'text',
                    'label' => esc_html__( 'Feature 3 More Button Label', 'lsvr-bluecollar-toolkit' ),
                    'default' => esc_html__( 'Learn More', 'lsvr-bluecollar-toolkit' ),
                    'priority' => 350,
                ),

                // Feature 3 More Link
                array(
                    'name' => 'feature3_more_link',
                    'type' => 'text',
                    'label' => esc_html__( 'Feature 3 More Button Link', 'lsvr-bluecollar-toolkit' ),
                    'default' => esc_html__( '#', 'lsvr-bluecollar-toolkit' ),
                    'priority' => 360,
                ),

                // Show top border
                array(
                    'name' => 'show_top_border',
                    'type' => 'checkbox',
                    'label' => esc_html__( 'Top Border', 'lsvr-bluecollar-toolkit' ),
                    'description' => esc_html__( 'Display top border.', 'lsvr-bluecollar-toolkit' ),
                    'priority' => 1000,
                ),

                // Push top
                array(
                    'name' => 'push_top',
                    'type' => 'checkbox',
                    'label' => esc_html__( 'Push Top', 'lsvr-bluecollar-toolkit' ),
                    'description' => esc_html__( 'Reduce top margin.', 'lsvr-bluecollar-toolkit' ),
                    'priority' => 1010,
                ),

                // ID
                array(
                    'name' => 'id',
                    'type' => 'text',
                    'label' => esc_html__( 'Unique ID', 'lsvr-bluecollar-toolkit' ),
                    'description' => esc_html__( 'You can use this ID to style this specific element with custom CSS, for example.', 'lsvr-bluecollar-toolkit' ),
                    'priority' => 2010,
                ),

            ), apply_filters( 'lsvr_bluecollar_features_shortcode_atts', array() ) );
        }

    }
}
?>