<?php
/**
 * LSVR BlueCollar Intro Shortcode
 */
if ( ! class_exists( 'Lsvr_Shortcode_Bluecollar_Intro' ) ) {
    class Lsvr_Shortcode_Bluecollar_Intro {

        public static function shortcode( $atts = array(), $content = null, $tag = '' ) {

            // Merge default atts and received atts
            $args = shortcode_atts(
                array(
                    'title' => '',
                    'text' => '',
                    'image' => '',
                    'button_label' => '',
                    'button_link' => '',
                    'bigger_title' => '',
                    'id' => '',
                    'className' => '',
                    'editor_view' => false,
                ),
                $atts
            );

            // Check if editor view
            $editor_view = true === $args['editor_view'] || '1' === $args['editor_view'] || 'true' === $args['editor_view'] ? true : false;

            // Bigger title
            $bigger_title = true === $args['bigger_title'] || '1' === $args['bigger_title'] || 'true' === $args['bigger_title'] ? true : false;

            // Background image
            if ( ( ! empty( $args['image'] ) && is_numeric( $args['image'] ) && (int) $args['image'] > 0 )
                || ( is_array( $args['image'] ) && ! empty( $args['image']['id'] ) ) ) {

                $image_id = is_array( $args['image'] ) && ! empty( $args['image']['id'] ) ? (int) $args['image']['id'] : (int) $args['image'];
                $image_data = wp_get_attachment_image_src( $image_id, 'full' );

                if ( ! empty( $image_data[0] ) ) {
                    $image_url = $image_data[0];
                }

                $image_alt = get_post_meta( $image_id, '_wp_attachment_image_alt', true );
                $image_alt = ! empty( $image_alt ) ? $image_alt : '';

            } elseif ( ! empty( $args['image'] ) && ! is_array( $args['image'] ) ) {

                $image_url = $args['image'];
                $image_alt = ! empty( $args['title'] ) ? $args['title'] : '';

            }

            // Element class
            $class_arr = array( 'lsvr-bluecollar-intro' );
            if ( true === $editor_view ) {
                array_push( $class_arr, 'lsvr-bluecollar-intro--editor-view' );
            }
            if ( ! empty( $image_url ) ) {
                array_push( $class_arr, 'lsvr-bluecollar-intro--has-image' );
            }
            if ( ! empty( $args['className'] ) ) {
                array_push( $class_arr, $args['className'] );
            }

            ob_start(); ?>

            <!-- BLUECOLLAR INTRO : begin -->
            <section class="<?php echo esc_attr( implode( ' ', $class_arr ) ); ?>"
                <?php echo ! empty( $args['id'] ) ? ' id="' . esc_attr( $args['id'] ) . '"' : ''; ?>>
                <div class="lsvr-bluecollar-intro__bg">
                    <div class="lsvr-container">
                        <div class="lsvr-bluecollar-intro__inner">

                            <div class="lsvr-bluecollar-intro__wrapper">

                                <?php if ( ! empty( $image_url ) ) : ?>

                                    <div class="lsvr-bluecollar-intro__image-col">
                                        <p class="lsvr-bluecollar-intro__image-wrapper">
                                            <img src="<?php echo esc_url( $image_url ); ?>" class="lsvr-bluecollar-intro__image"
                                                alt="<?php echo esc_attr( $image_alt ); ?>">
                                        </p>
                                    </div>

                                <?php endif; ?>

                                <div class="lsvr-bluecollar-intro__text-col">

                                    <?php if ( ! empty( $args['title'] ) ) : ?>

                                        <?php if ( true === $bigger_title ) : ?>

                                            <h1 class="lsvr-bluecollar-intro__title">
                                                <?php echo wp_kses( $args['title'], array(
                                                    'a' => array(
                                                        'href' => '',
                                                    ),
                                                    'br' => array(),
                                                    'span' => array(
                                                        'class' => array(),
                                                        'style' => array(),
                                                    ),
                                                    'strong' => array(),
                                                ) ); ?>
                                            </h1>

                                        <?php else : ?>

                                            <h2 class="lsvr-bluecollar-intro__title">
                                                <?php echo wp_kses( $args['title'], array(
                                                    'a' => array(
                                                        'href' => '',
                                                    ),
                                                    'br' => array(),
                                                    'span' => array(
                                                        'class' => array(),
                                                        'style' => array(),
                                                    ),
                                                    'strong' => array(),
                                                ) ); ?>
                                            </h2>

                                        <?php endif; ?>

                                    <?php endif; ?>

                                    <?php if ( ! empty( $args['text'] ) ) : ?>

                                        <div class="lsvr-bluecollar-intro__content">
                                            <?php echo wpautop( wp_kses( $args['text'], array(
                                                'a' => array(
                                                    'href' => '',
                                                ),
                                                'br' => array(),
                                                'strong' => array(),
                                            ) ) ); ?>
                                        </div>

                                    <?php endif; ?>

                                    <?php if ( ! empty( $args['button_label'] ) && ! empty( $args['button_link'] ) ) : ?>

                                        <p class="lsvr-bluecollar-intro__more">
                                            <a href="<?php echo esc_url( $args['button_link'] ); ?>"
                                                 class="c-button lsvr-bluecollar-intro__more-link"><?php echo esc_html( $args['button_label'] ); ?></a>
                                        </p>

                                    <?php endif; ?>

                                </div>

                            </div>

                        </div>
                    </div>
                </div>
            </section>
            <!-- BLUECOLLAR INTRO : end -->

            <?php return ob_get_clean();

        }

        // Shortcode params
        public static function lsvr_shortcode_atts() {
            return array_merge( array(

                // Title
                array(
                    'name' => 'title',
                    'type' => 'text',
                    'label' => esc_html__( 'Title', 'lsvr-bluecollar-toolkit' ),
                    'default' => esc_html__( 'Lorem ipsum dolor sit amet', 'lsvr-bluecollar-toolkit' ),
                    'priority' => 10,
                ),

                // Text
                array(
                    'name' => 'text',
                    'type' => 'textarea',
                    'label' => esc_html__( 'Text', 'lsvr-bluecollar-toolkit' ),
                    'default' => esc_html__( 'Aenean commodo ligula eget dolor.', 'lsvr-bluecollar-toolkit' ),
                    'priority' => 20,
                ),

                // Image
                array(
                    'name' => 'image',
                    'type' => 'image',
                    'label' => esc_html__( 'Image', 'lsvr-bluecollar-toolkit' ),
                    'priority' => 30,
                ),

                // Button label
                array(
                    'name' => 'button_label',
                    'type' => 'text',
                    'label' => esc_html__( 'Button Label', 'lsvr-bluecollar-toolkit' ),
                    'default' => esc_html__( 'Learn More', 'lsvr-bluecollar-toolkit' ),
                    'priority' => 50,
                ),

                // Button link
                array(
                    'name' => 'button_link',
                    'type' => 'text',
                    'label' => esc_html__( 'Button Link', 'lsvr-bluecollar-toolkit' ),
                    'default' => esc_html__( '#', 'lsvr-bluecollar-toolkit' ),
                    'priority' => 60,
                ),

                // Bigger title
                array(
                    'name' => 'bigger_title',
                    'type' => 'checkbox',
                    'label' => esc_html__( 'Bigger Title', 'lsvr-bluecollar-toolkit' ),
                    'description' => esc_html__( 'Make the section title bigger.', 'lsvr-bluecollar-toolkit' ),
                    'priority' => 70,
                ),

                // ID
                array(
                    'name' => 'id',
                    'type' => 'text',
                    'label' => esc_html__( 'Unique ID', 'lsvr-bluecollar-toolkit' ),
                    'description' => esc_html__( 'You can use this ID to style this specific element with custom CSS, for example.', 'lsvr-bluecollar-toolkit' ),
                    'priority' => 210,
                ),

            ), apply_filters( 'lsvr_bluecollar_intro_shortcode_atts', array() ) );
        }

    }
}
?>