<?php
/**
 * LSVR BlueCollar Posts Shortcode
 */
if ( ! class_exists( 'Lsvr_Shortcode_Bluecollar_Posts' ) ) {
    class Lsvr_Shortcode_Bluecollar_Posts {

        public static function shortcode( $atts = array(), $content = null, $tag = '' ) {

            // Merge default atts and received atts
            $args = shortcode_atts(
                array(
                    'title' => '',
                    'category' => 0,
                    'limit' => 6,
                    'columns' => 3,
                    'background_image' => '',
                    'colored_background' => '',
                    'centered_title' => '',
                    'show_date' => '',
                    'show_category' => '',
                    'show_excerpt' => '',
                    'enable_masonry' => '',
                    'more_label' => '',
                    'id' => '',
                    'className' => '',
                    'editor_view' => false,
                ),
                $atts
            );

            // Prepare grid and cols classes
            $grid_class = 'lsvr-grid lsvr-grid--' . $args['columns'] . '-cols';
            $grid_class .= (int) $args['columns'] > 1 ? ' lsvr-grid--md-2-cols' : '';
            $col_class = 'lsvr-grid__col lsvr-grid__col--span-' . esc_attr( 12 / (int) $args['columns'] );
            $col_class .= (int) $args['columns'] > 1 ? ' lsvr-grid__col--md-span-6' : '';

            // Check if editor view
            $editor_view = true === $args['editor_view'] || '1' === $args['editor_view'] || 'true' === $args['editor_view'] ? true : false;

            // Enable colored background
            $colored_background = true === $args['colored_background'] || '1' === $args['colored_background'] || 'true' === $args['colored_background'] ? true : false;

            // Enable centered title
            $centered_title = true === $args['centered_title'] || '1' === $args['centered_title'] || 'true' === $args['centered_title'] ? true : false;

            // Enable date
            $show_date = true === $args['show_date'] || '1' === $args['show_date'] || 'true' === $args['show_date'] ? true : false;

            // Enable category
            $show_category = true === $args['show_category'] || '1' === $args['show_category'] || 'true' === $args['show_category'] ? true : false;

            // Enable excerpt
            $show_excerpt = true === $args['show_excerpt'] || '1' === $args['show_excerpt'] || 'true' === $args['show_excerpt'] ? true : false;

            // Enable masonry
            $enable_masonry = true === $args['enable_masonry'] || '1' === $args['enable_masonry'] || 'true' === $args['enable_masonry'] ? true : false;

            // Background image
            if ( ( ! empty( $args['background_image'] ) && is_numeric( $args['background_image'] ) && (int) $args['background_image'] > 0 )
                || ( is_array( $args['background_image'] ) && ! empty( $args['background_image']['id'] ) ) ) {

                $image_id = is_array( $args['background_image'] ) && ! empty( $args['background_image']['id'] ) ? (int) $args['background_image']['id'] : (int) $args['background_image'];
                $image_data = wp_get_attachment_image_src( $image_id, 'full' );

                if ( ! empty( $image_data[0] ) ) {
                    $background_url = $image_data[0];
                }

            } elseif ( ! empty( $args['background_image'] ) && ! is_array( $args['background_image'] ) ) {
                $background_url = $args['background_image'];
            }

            // Get thumb size
            if ( (int) $args['columns'] > 2 ) {
                $thumb_size = 'medium';
            } else {
                $thumb_size = 'full';
            }

            // Element class
            $class_arr = array( 'lsvr-bluecollar-posts' );
            if ( true === $editor_view ) {
                array_push( $class_arr, 'lsvr-bluecollar-posts--editor-view' );
            }
            if ( true === $colored_background ) {
                array_push( $class_arr, 'lsvr-bluecollar-posts--has-background-color' );
            }
            if ( ! empty( $background_url ) ) {
                array_push( $class_arr, 'lsvr-bluecollar-posts--has-background-image' );
            }
            if ( true === $enable_masonry ) {
                array_push( $class_arr, 'lsvr-bluecollar-posts--is-masonry' );
            }
            if ( ! empty( $args['className'] ) ) {
                array_push( $class_arr, $args['className'] );
            }

            // Prepare query
            $limit = 0 === (int) $args['limit'] ? 1000 : (int) $args['limit'];
            $query_args = array(
                'posts_per_page' => $limit,
                'post_type' => 'post',
            );

            // Get category
            if ( ! empty( $args['category'] ) && is_numeric( $args['category'] ) && (int) $args['category'] > 0 ) {
                $category_id = (int) $args['category'];
            } else if ( ! empty( $args['category'] ) ) {
                $category_id = get_term_by( 'slug', $args['category'], 'category', ARRAY_A );
                $category_id = ! empty( $category_id['term_taxonomy_id'] ) ? $category_id['term_taxonomy_id'] : false;
            } else {
                $category_id = false;
            }

            // Set category
            if ( ! empty( $category_id ) ) {
                $query_args['category'] = $category_id;
            }

            // Get posts
            $posts = get_posts( $query_args );

            ob_start(); ?>

            <!-- BLUECOLLAR POSTS : begin -->
            <section class="<?php echo esc_attr( implode( ' ', $class_arr ) ); ?>"
                <?php echo ! empty( $args['id'] ) ? ' id="' . esc_attr( $args['id'] ) . '"' : ''; ?>>
                <div class="lsvr-bluecollar-posts__bg"
                    <?php if ( ! empty( $background_url ) ) { echo ' style="background-image: url( \'' . esc_url( $background_url ) . '\');"'; } ?>>
                    <div class="lsvr-bluecollar-posts__inner">
                        <div class="lsvr-container">
                            <div class="lsvr-bluecollar-posts__content">

                                <?php if ( ! empty( $args['title'] ) ) : ?>
                                    <header class="lsvr-bluecollar-posts__header">

                                         <?php if ( ! empty( $args['title'] ) && true === $centered_title ) : ?>

                                            <h1 class="lsvr-bluecollar-posts__title lsvr-bluecollar-posts__title--centered">
                                                <?php echo wp_kses( $args['title'], array(
                                                    'a' => array(
                                                        'href' => '',
                                                    ),
                                                    'br' => array(),
                                                    'span' => array(
                                                        'class' => array(),
                                                        'style' => array(),
                                                    ),
                                                    'strong' => array(),
                                                ) ); ?>
                                            </h1>

                                        <?php elseif ( ! empty( $args['title'] ) ) : ?>

                                            <h2 class="lsvr-bluecollar-posts__title">
                                                <?php echo wp_kses( $args['title'], array(
                                                    'a' => array(
                                                        'href' => '',
                                                    ),
                                                    'br' => array(),
                                                    'span' => array(
                                                        'class' => array(),
                                                        'style' => array(),
                                                    ),
                                                    'strong' => array(),
                                                ) ); ?>
                                            </h2>

                                        <?php endif; ?>

                                    </header>
                                <?php endif; ?>

                                <?php if ( ! empty( $posts ) ) : ?>

                                    <div class="<?php echo esc_attr( $grid_class ); ?> lsvr-bluecollar-posts__list">

                                        <?php foreach ( $posts as $post ) : ?>

                                            <div class="<?php echo esc_attr( $col_class ); ?> lsvr-bluecollar-posts__item">

                                                <article <?php post_class( 'lsvr-bluecollar-posts__post', $post->ID ); ?>>
                                                    <div class="lsvr-bluecollar-posts__post-inner">

                                                        <?php if ( has_post_thumbnail( $post->ID ) ) : ?>

                                                            <p class="lsvr-bluecollar-posts__post-thumbnail">
                                                                <a href="<?php echo esc_url( get_the_permalink( $post->ID ) ); ?>"
                                                                     class="lsvr-bluecollar-posts__post-thumbnail-link">
                                                                    <?php echo get_the_post_thumbnail( $post->ID, $thumb_size ); ?>
                                                                </a>
                                                            </p>

                                                        <?php endif; ?>

                                                        <header class="lsvr-bluecollar-posts__post-header">

                                                            <h3 class="lsvr-bluecollar-posts__post-title">
                                                                <a href="<?php echo esc_url( get_the_permalink( $post->ID ) ); ?>" class="lsvr-bluecollar-posts__post-title-link" rel="bookmark"><?php echo esc_html( $post->post_title ); ?></a>
                                                            </h3>

                                                            <?php if ( true === $show_date || true === $show_category ) : ?>

                                                                <p class="lsvr-bluecollar-posts__post-meta">

                                                                    <?php if ( true === $show_date ) : ?>

                                                                        <time class="lsvr-bluecollar-posts__post-meta-date" datetime="<?php echo esc_attr( get_the_time( 'c', $post->ID  ) ); ?>"><?php echo get_the_date( get_option( 'post_format' ), $post->ID ); ?></time>

                                                                    <?php endif; ?>

                                                                    <?php if ( true === $show_category && lsvr_bluecollar_toolkit_has_post_terms( $post->ID, 'category') ) :?>

                                                                        <span class="lsvr-bluecollar-posts__post-meta-categories">
                                                                            <?php lsvr_bluecollar_toolkit_the_post_terms( $post->ID, 'category', esc_html__( 'in %s', 'lsvr-bluecollar-toolkit' ) ); ?>
                                                                        </span>

                                                                    <?php endif; ?>

                                                                </p>

                                                            <?php endif; ?>

                                                        </header>

                                                        <?php if ( true === $show_excerpt && has_excerpt( $post->ID ) ) : ?>

                                                            <div class="lsvr-bluecollar-posts__post-content">

                                                                <?php echo wpautop( get_the_excerpt( $post->ID ) ); ?>

                                                                <p class="lsvr-bluecollar-posts__post-permalink">

                                                                   <a href="<?php echo esc_url( get_the_permalink( $post->ID ) ); ?>" class="lsvr-bluecollar-posts__post-permalink-link">
                                                                        <?php esc_html_e( 'Read More', 'lsvr-bluecollar-toolkit' ); ?>
                                                                    </a>
                                                                </p>

                                                            </div>

                                                        <?php endif; ?>

                                                    </div>
                                                </article>

                                            </div>

                                        <?php endforeach; wp_reset_postdata(); ?>

                                    </div>

                                <?php else : ?>

                                    <p class="c-alert-message"><?php esc_html_e( 'There are no posts', 'lsvr-bluecollar-toolkit' ); ?></p>

                                <?php endif; ?>

                                <?php if ( ! empty( $args[ 'more_label' ] ) ) : ?>

                                    <footer class="lsvr-bluecollar-posts__footer">

                                        <p class="lsvr-bluecollar-posts__more">

                                            <?php if ( ! empty( $category_id ) ) : ?>

                                                <a href="<?php echo esc_url( get_term_link( $category_id, 'category' ) ); ?>" class="c-button lsvr-bluecollar-posts__more-link"><?php echo esc_html( $args[ 'more_label' ] ); ?></a>

                                            <?php else : ?>

                                                <a href="<?php echo esc_url( get_post_type_archive_link( 'post' ) ); ?>" class="c-button lsvr-bluecollar-posts__more-link"><?php echo esc_html( $args[ 'more_label' ] ); ?></a>

                                            <?php endif; ?>

                                        </p>

                                    </footer>

                                <?php endif; ?>

                            </div>
                        </div>
                    </div>
                </div>
            </section>
            <!-- BLUECOLLAR POSTS : end -->

            <?php return ob_get_clean();

        }

        // Shortcode params
        public static function lsvr_shortcode_atts() {
            return array_merge( array(

                // Title
                array(
                    'name' => 'title',
                    'type' => 'text',
                    'label' => esc_html__( 'Title', 'lsvr-bluecollar-toolkit' ),
                    'default' => esc_html__( 'Latest Posts', 'lsvr-bluecollar-toolkit' ),
                    'priority' => 10,
                ),

                // Category
                array(
                    'name' => 'category',
                    'type' => 'taxonomy',
                    'tax' => 'category',
                    'label' => esc_html__( 'Category', 'lsvr-bluecollar-toolkit' ),
                    'description' => esc_html__( 'Display posts from a specific category.', 'lsvr-bluecollar-toolkit' ),
                    'priority' => 20,
                ),

                // Limit
                array(
                    'name' => 'limit',
                    'type' => 'select',
                    'label' => esc_html__( 'Limit', 'lsvr-bluecollar-toolkit' ),
                    'description' => esc_html__( 'How many posts should be displayed.', 'lsvr-bluecollar-toolkit' ),
                    'choices' => array( 0 => esc_html__( 'All', 'lsvr-bluecollar-toolkit' ) ) + range( 0, 20, 1 ),
                    'default' => 6,
                    'priority' => 30,
                ),

                // Columns count
                array(
                    'name' => 'columns',
                    'type' => 'select',
                    'label' => esc_html__( 'Number of Columns', 'lsvr-bluecollar-toolkit' ),
                    'description' => esc_html__( 'How many columns should be used to display posts.', 'lsvr-bluecollar-toolkit' ),
                    'choices' => array( 1 => 1, 2 => 2, 3 => 3, 4 => 4 ),
                    'default' => 3,
                    'priority' => 40,
                ),

                // Background image
                array(
                    'name' => 'background_image',
                    'type' => 'image',
                    'label' => esc_html__( 'Background Image', 'lsvr-bluecollar-toolkit' ),
                    'description' => esc_html__( 'Background image of this section.', 'lsvr-bluecollar-toolkit' ),
                    'priority' => 50,
                ),

                // Colored background
                array(
                    'name' => 'colored_background',
                    'type' => 'checkbox',
                    'label' => esc_html__( 'Display Colored Background', 'lsvr-bluecollar-toolkit' ),
                    'description' => esc_html__( 'Make this section stand out. If you are using background image, it will use color overlay.', 'lsvr-bluecollar-toolkit' ),
                    'priority' => 55,
                ),

                // Centered title
                array(
                    'name' => 'centered_title',
                    'type' => 'checkbox',
                    'label' => esc_html__( 'Centered Title', 'lsvr-bluecollar-toolkit' ),
                    'description' => esc_html__( 'Center the section title.', 'lsvr-bluecollar-toolkit' ),
                    'priority' => 60,
                ),

                // Show date
                array(
                    'name' => 'show_date',
                    'type' => 'checkbox',
                    'label' => esc_html__( 'Display Date', 'lsvr-bluecollar-toolkit' ),
                    'description' => esc_html__( 'Display post date.', 'lsvr-bluecollar-toolkit' ),
                    'priority' => 70,
                ),

                // Show category
                array(
                    'name' => 'show_category',
                    'type' => 'checkbox',
                    'label' => esc_html__( 'Display Category', 'lsvr-bluecollar-toolkit' ),
                    'description' => esc_html__( 'Display post category.', 'lsvr-bluecollar-toolkit' ),
                    'priority' => 80,
                ),

                // Show excerpt
                array(
                    'name' => 'show_excerpt',
                    'type' => 'checkbox',
                    'label' => esc_html__( 'Display Excerpt', 'lsvr-bluecollar-toolkit' ),
                    'description' => esc_html__( 'Display post excerpt.', 'lsvr-bluecollar-toolkit' ),
                    'priority' => 90,
                ),

                // Enable masonry
                array(
                    'name' => 'enable_masonry',
                    'type' => 'checkbox',
                    'label' => esc_html__( 'Enable Masonry', 'lsvr-bluecollar-toolkit' ),
                    'description' => esc_html__( 'Display posts grid using masonry layout.', 'lsvr-bluecollar-toolkit' ),
                    'priority' => 100,
                ),

                // More label
                array(
                    'name' => 'more_label',
                    'type' => 'text',
                    'label' => esc_html__( 'More Button Label', 'lsvr-bluecollar-toolkit' ),
                    'description' => esc_html__( 'Link to post archive. Leave blank to hide.', 'lsvr-bluecollar-toolkit' ),
                    'default' => esc_html__( 'More Posts', 'lsvr-bluecollar-toolkit' ),
                    'priority' => 200,
                ),

                // ID
                array(
                    'name' => 'id',
                    'type' => 'text',
                    'label' => esc_html__( 'Unique ID', 'lsvr-bluecollar-toolkit' ),
                    'description' => esc_html__( 'You can use this ID to style this specific element with custom CSS, for example.', 'lsvr-bluecollar-toolkit' ),
                    'priority' => 220,
                ),

            ), apply_filters( 'lsvr_bluecollar_posts_shortcode_atts', array() ) );
        }

    }
}
?>