<?php
/**
 * LSVR BlueCollar Services Shortcode
 */
if ( ! class_exists( 'Lsvr_Shortcode_Bluecollar_Services' ) ) {
    class Lsvr_Shortcode_Bluecollar_Services {

        public static function shortcode( $atts = array(), $content = null, $tag = '' ) {

            // Merge default atts and received atts
            $args = shortcode_atts(
                array(
                    'title' => '',
                    'category' => 0,
                    'limit' => 8,
                    'order' => '',
                    'columns' => 4,
                    'background_image' => '',
                    'colored_background' => '',
                    'fullwidth_layout' => '',
                    'centered_title' => '',
                    'stick_to_bottom' => '',
                    'show_category' => '',
                    'show_excerpt' => '',
                    'more_label' => '',
                    'id' => '',
                    'className' => '',
                    'editor_view' => false,
                ),
                $atts
            );

            // Prepare grid and cols classes
            $grid_class = 'lsvr-grid lsvr-grid--' . $args['columns'] . '-cols';
            $grid_class .= (int) $args['columns'] > 1 ? ' lsvr-grid--md-2-cols lsvr-grid--sm-2-cols' : '';
            $col_class = 'lsvr-grid__col lsvr-grid__col--span-' . esc_attr( 12 / (int) $args['columns'] );
            $col_class .= (int) $args['columns'] > 1 ? ' lsvr-grid__col--md-span-6 lsvr-grid__col--sm-span-6' : '';

            // Check if editor view
            $editor_view = true === $args['editor_view'] || '1' === $args['editor_view'] || 'true' === $args['editor_view'] ? true : false;

            // Enable colored background
            $colored_background = true === $args['colored_background'] || '1' === $args['colored_background'] || 'true' === $args['colored_background'] ? true : false;

            // Enable fullwidth layout
            $fullwidth_layout = true === $args['fullwidth_layout'] || '1' === $args['fullwidth_layout'] || 'true' === $args['fullwidth_layout'] ? true : false;

            // Enable centered title
            $centered_title = true === $args['centered_title'] || '1' === $args['centered_title'] || 'true' === $args['centered_title'] ? true : false;

            // Enable stick to bottom
            $stick_to_bottom = true === $args['stick_to_bottom'] || '1' === $args['stick_to_bottom'] || 'true' === $args['stick_to_bottom'] ? true : false;

            // Enable category
            $enable_category = true === $args['show_category'] || '1' === $args['show_category'] || 'true' === $args['show_category'] ? true : false;

            // Enable excerpt
            $enable_excerpt = true === $args['show_excerpt'] || '1' === $args['show_excerpt'] || 'true' === $args['show_excerpt'] ? true : false;

            // Background image
            if ( ( ! empty( $args['background_image'] ) && is_numeric( $args['background_image'] ) && (int) $args['background_image'] > 0 )
                || ( is_array( $args['background_image'] ) && ! empty( $args['background_image']['id'] ) ) ) {

                $image_id = is_array( $args['background_image'] ) && ! empty( $args['background_image']['id'] ) ? (int) $args['background_image']['id'] : (int) $args['background_image'];
                $image_data = wp_get_attachment_image_src( $image_id, 'full' );

                if ( ! empty( $image_data[0] ) ) {
                    $background_url = $image_data[0];
                }

            } elseif ( ! empty( $args['background_image'] ) && ! is_array( $args['background_image'] ) ) {
                $background_url = $args['background_image'];
            }

            // Get thumb size
            if ( (int) $args['columns'] > 2 ) {
                $thumb_size = 'medium';
            } else {
                $thumb_size = 'full';
            }

            // Element class
            $class_arr = array( 'lsvr-bluecollar-services' );
            if ( true === $editor_view ) {
                array_push( $class_arr, 'lsvr-bluecollar-services--editor-view' );
            }
            if ( true === $colored_background ) {
                array_push( $class_arr, 'lsvr-bluecollar-services--has-background-color' );
            }
            if ( ! empty( $background_url ) ) {
                array_push( $class_arr, 'lsvr-bluecollar-services--has-background-image' );
            }
            if ( true === $fullwidth_layout ) {
                array_push( $class_arr, 'lsvr-bluecollar-services--fullwidth-layout' );
            }
            if ( true === $stick_to_bottom ) {
                array_push( $class_arr, 'lsvr-bluecollar-services--stick-to-bottom' );
            }
            if ( true === $centered_title ) {
                array_push( $class_arr, 'lsvr-bluecollar-services--has-centered-title' );
            }
            if ( ! empty( $args['more_label'] ) ) {
                array_push( $class_arr, 'lsvr-bluecollar-services--has-more-link' );
            }
            if ( ! empty( $args['className'] ) ) {
                array_push( $class_arr, $args['className'] );
            }

            // Prepare query
            $limit = 0 === (int) $args['limit'] ? 1000 : (int) $args['limit'];
            $query_args = array(
                'posts_per_page' => $limit,
                'post_type' => 'lsvr_service',
            );

            // Set order
            if ( ! empty( $args['order'] ) && 'default' !== $args['order'] ) {
                if ( 'date_desc' == $args['order'] ) {
                    $query_args['orderby'] = 'date';
                    $query_args['order'] = 'DESC';
                }
                elseif ( 'date_asc' == $args['order'] ) {
                    $query_args['orderby'] = 'date';
                    $query_args['order'] = 'ASC';
                }
                elseif ( 'title_asc' == $args['order'] ) {
                    $query_args['orderby'] = 'title';
                    $query_args['order'] = 'ASC';
                }
                elseif ( 'title_desc' == $args['order'] ) {
                    $query_args['orderby'] = 'title';
                    $query_args['order'] = 'DESC';
                }
                elseif ( 'random' == $args['order'] ) {
                    $query_args['orderby'] = 'rand';
                }
            }

            // Get category
            if ( ! empty( $args['category'] ) && is_numeric( $args['category'] ) && (int) $args['category'] > 0 ) {
                $category_id = (int) $args['category'];
            } else if ( ! empty( $args['category'] ) ) {
                $category_id = get_term_by( 'slug', $args['category'], 'lsvr_service_cat', ARRAY_A );
                $category_id = ! empty( $category_id['term_taxonomy_id'] ) ? $category_id['term_taxonomy_id'] : false;
            } else {
                $category_id = false;
            }

            // Set category
            if ( ! empty( $category_id ) ) {
                $query_args['tax_query'] = array(
                    array(
                        'taxonomy' => 'lsvr_service_cat',
                        'field' => 'ID',
                        'terms' => array( $category_id ),
                        'operator' => 'IN',
                    ),
                );
            }

            // Get posts
            $posts = get_posts( $query_args );

            ob_start(); ?>

            <!-- BLUECOLLAR SERVICES : begin -->
            <section class="<?php echo esc_attr( implode( ' ', $class_arr ) ); ?>"
                <?php echo ! empty( $args['id'] ) ? ' id="' . esc_attr( $args['id'] ) . '"' : ''; ?>>
                <div class="lsvr-bluecollar-services__bg"
                    <?php if ( ! empty( $background_url ) ) { echo ' style="background-image: url( \'' . esc_url( $background_url ) . '\');"'; } ?>>
                    <div class="lsvr-bluecollar-services__inner">
                        <div class="lsvr-bluecollar-services__content">

                            <?php if ( ! empty( $args['title'] ) ) : ?>
                                <header class="lsvr-bluecollar-services__header">
                                    <div class="lsvr-container">

                                        <?php if ( ! empty( $args['title'] ) && true === $centered_title ) : ?>

                                            <h1 class="lsvr-bluecollar-services__title lsvr-bluecollar-services__title--centered">
                                                <?php echo wp_kses( $args['title'], array(
                                                    'a' => array(
                                                        'href' => '',
                                                    ),
                                                    'br' => array(),
                                                    'span' => array(
                                                        'class' => array(),
                                                        'style' => array(),
                                                    ),
                                                    'strong' => array(),
                                                ) ); ?>
                                            </h1>

                                        <?php elseif ( ! empty( $args['title'] ) ) : ?>

                                            <h2 class="lsvr-bluecollar-services__title">
                                                <?php echo wp_kses( $args['title'], array(
                                                    'a' => array(
                                                        'href' => '',
                                                    ),
                                                    'br' => array(),
                                                    'span' => array(
                                                        'class' => array(),
                                                        'style' => array(),
                                                    ),
                                                    'strong' => array(),
                                                ) ); ?>
                                            </h2>

                                        <?php endif; ?>

                                    </div>
                                </header>
                            <?php endif; ?>

                            <?php if ( ! empty( $posts ) ) : ?>

                                <div class="lsvr-bluecollar-services__list-wrapper">
                                    <div class="lsvr-container">

                                        <div class="<?php echo esc_attr( $grid_class ); ?> lsvr-bluecollar-services__list">

                                            <?php foreach ( $posts as $post ) : ?>

                                                <div class="<?php echo esc_attr( $col_class ); ?> lsvr-bluecollar-services__item <?php if ( has_post_thumbnail( $post->ID ) ) { echo ' lsvr-bluecollar-services__item--has-thumbnail'; } ?>">

                                                    <article <?php post_class( 'lsvr-bluecollar-services__post', $post->ID ); ?>>
                                                        <div class="lsvr-bluecollar-services__post-bg"
                                                            <?php if ( has_post_thumbnail( $post->ID ) ) { echo ' style="background-image: url(\'' . esc_url( get_the_post_thumbnail_url( $post->ID, $thumb_size ) ) . '\');"'; } ?>>
                                                            <div class="lsvr-bluecollar-services__post-inner">

                                                                <header class="lsvr-bluecollar-services__post-header">
                                                                    <div class="lsvr-bluecollar-services__post-header-inner">

                                                                        <?php if ( ! empty( get_post_meta( $post->ID, 'lsvr_service_icon_class', true ) ) ) : ?>
                                                                            <i class="lsvr-bluecollar-services__post-icon <?php echo esc_attr( get_post_meta( $post->ID, 'lsvr_service_icon_class', true ) ); ?>"></i>
                                                                        <?php endif; ?>

                                                                        <h3 class="lsvr-bluecollar-services__post-title">
                                                                            <a href="<?php echo esc_url( get_the_permalink( $post->ID ) ); ?>" class="lsvr-bluecollar-services__post-title-link" rel="bookmark">
                                                                                <?php echo esc_html( $post->post_title ); ?>
                                                                            </a>
                                                                        </h3>

                                                                        <?php if ( true === $enable_category && ! empty( lsvr_bluecollar_toolkit_has_post_terms( $post->ID, 'lsvr_service_cat' ) ) ) :?>

                                                                            <p class="lsvr-bluecollar-services__post-meta">
                                                                                <span class="lsvr-bluecollar-services__post-meta-categories">
                                                                                    <?php lsvr_bluecollar_toolkit_the_post_terms( $post->ID, 'lsvr_service_cat', esc_html__( '%s', 'lsvr-bluecollar-toolkit' ) ); ?>
                                                                                </span>
                                                                            </p>

                                                                        <?php endif; ?>

                                                                    </div>
                                                                </header>

                                                                <?php if ( true === $enable_excerpt && has_excerpt( $post->ID ) ) : ?>

                                                                    <div class="lsvr-bluecollar-services__post-description">
                                                                        <div class="lsvr-bluecollar-services__post-description-inner">
                                                                            <?php echo wpautop( get_the_excerpt( $post->ID ) ); ?>
                                                                        </div>
                                                                    </div>

                                                                <?php endif; ?>

                                                                <a href="<?php echo esc_url( get_permalink( $post->ID ) ); ?>"
                                                                    class="lsvr-bluecollar-services__post-overlay-link">
                                                                    <span class="screen-reader-text"><?php esc_html_e( 'More Info', 'lsvr-bluecollar-toolkit' ); ?></span>
                                                                </a>

                                                            </div>
                                                        </div>
                                                    </article>

                                                </div>

                                            <?php endforeach; wp_reset_postdata(); ?>

                                        </div>

                                    </div>
                                </div>

                            <?php else : ?>

                                <div class="lsvr-container">
                                    <p class="c-alert-message"><?php esc_html_e( 'There are no services', 'lsvr-bluecollar-toolkit' ); ?></p>
                                </div>

                            <?php endif; ?>

                            <?php if ( ! empty( $args[ 'more_label' ] ) ) : ?>

                                <footer class="lsvr-bluecollar-services__footer">
                                    <div class="lsvr-container">
                                        <div class="lsvr-bluecollar-services__footer-inner">

                                            <p class="lsvr-bluecollar-services__more">

                                                <?php if ( ! empty( $category_id ) ) : ?>

                                                    <a href="<?php echo esc_url( get_term_link( $category_id, 'lsvr_service_cat' ) ); ?>" class="c-button lsvr-bluecollar-services__more-link"><?php echo esc_html( $args[ 'more_label' ] ); ?></a>

                                                <?php else : ?>

                                                    <a href="<?php echo esc_url( get_post_type_archive_link( 'lsvr_service' ) ); ?>" class="c-button lsvr-bluecollar-services__more-link"><?php echo esc_html( $args[ 'more_label' ] ); ?></a>

                                                <?php endif; ?>

                                            </p>

                                        </div>
                                    </div>
                                </footer>

                            <?php endif; ?>

                        </div>
                    </div>
                </div>
            </section>
            <!-- BLUECOLLAR SERVICES : end -->

            <?php return ob_get_clean();

        }

        // Shortcode params
        public static function lsvr_shortcode_atts() {
            return array_merge( array(

                // Title
                array(
                    'name' => 'title',
                    'type' => 'text',
                    'label' => esc_html__( 'Title', 'lsvr-bluecollar-toolkit' ),
                    'default' => esc_html__( 'Services', 'lsvr-bluecollar-toolkit' ),
                    'priority' => 10,
                ),

                // Category
                array(
                    'name' => 'category',
                    'type' => 'taxonomy',
                    'tax' => 'lsvr_service_cat',
                    'label' => esc_html__( 'Category', 'lsvr-bluecollar-toolkit' ),
                    'description' => esc_html__( 'Display services posts from a specific category.', 'lsvr-bluecollar-toolkit' ),
                    'priority' => 20,
                ),

                // Limit
                array(
                    'name' => 'limit',
                    'type' => 'select',
                    'label' => esc_html__( 'Limit', 'lsvr-bluecollar-toolkit' ),
                    'description' => esc_html__( 'How many services posts should be displayed.', 'lsvr-bluecollar-toolkit' ),
                    'choices' => array( 0 => esc_html__( 'All', 'lsvr-bluecollar-toolkit' ) ) + range( 0, 20, 1 ),
                    'default' => 8,
                    'priority' => 30,
                ),

                // Order
                array(
                    'name' => 'order',
                    'type' => 'select',
                    'label' => esc_html__( 'Order', 'lsvr-bluecollar-toolkit' ),
                    'description' => esc_html__( 'Order of service posts.', 'lsvr-bluecollar-toolkit' ),
                    'choices' => array(
                        'default' => esc_html__( 'Default', 'lsvr-bluecollar-toolkit' ),
                        'date_desc' => esc_html__( 'By date, newest first', 'lsvr-bluecollar-toolkit' ),
                        'date_asc' => esc_html__( 'By date, oldest first', 'lsvr-bluecollar-toolkit' ),
                        'title_asc' => esc_html__( 'By title, ascending', 'lsvr-bluecollar-toolkit' ),
                        'title_desc' => esc_html__( 'By title, descending', 'lsvr-bluecollar-toolkit' ),
                        'random' => esc_html__( 'Random', 'lsvr-bluecollar-toolkit' ),
                    ),
                    'default' => 'default',
                    'priority' => 35,
                ),

                // Columns count
                array(
                    'name' => 'columns',
                    'type' => 'select',
                    'label' => esc_html__( 'Number of Columns', 'lsvr-bluecollar-toolkit' ),
                    'description' => esc_html__( 'How many columns should be used to display service posts.', 'lsvr-bluecollar-toolkit' ),
                    'choices' => array( 1 => 1, 2 => 2, 3 => 3, 4 => 4 ),
                    'default' => 4,
                    'priority' => 40,
                ),

                // Background image
                array(
                    'name' => 'background_image',
                    'type' => 'image',
                    'label' => esc_html__( 'Background Image', 'lsvr-bluecollar-toolkit' ),
                    'description' => esc_html__( 'Background image of this section.', 'lsvr-bluecollar-toolkit' ),
                    'priority' => 50,
                ),

                // Colored background
                array(
                    'name' => 'colored_background',
                    'type' => 'checkbox',
                    'label' => esc_html__( 'Display Colored Background', 'lsvr-bluecollar-toolkit' ),
                    'description' => esc_html__( 'Make this section stand out. If you are using background image, it will use color overlay.', 'lsvr-bluecollar-toolkit' ),
                    'priority' => 55,
                ),

                // Fullwidth layout
                array(
                    'name' => 'fullwidth_layout',
                    'type' => 'checkbox',
                    'label' => esc_html__( 'Fullwidth Layout', 'lsvr-bluecollar-toolkit' ),
                    'description' => esc_html__( 'Stretch services grid to full content width.', 'lsvr-bluecollar-toolkit' ),
                    'priority' => 60,
                ),

                // Centered title
                array(
                    'name' => 'centered_title',
                    'type' => 'checkbox',
                    'label' => esc_html__( 'Centered Title', 'lsvr-bluecollar-toolkit' ),
                    'description' => esc_html__( 'Center the section title.', 'lsvr-bluecollar-toolkit' ),
                    'priority' => 70,
                ),

                // Stick to bottom
                array(
                    'name' => 'stick_to_bottom',
                    'type' => 'checkbox',
                    'label' => esc_html__( 'Stick To Bottom', 'lsvr-bluecollar-toolkit' ),
                    'description' => esc_html__( 'Remove the bottom padding if possible.', 'lsvr-bluecollar-toolkit' ),
                    'priority' => 80,
                ),

                // Show category
                array(
                    'name' => 'show_category',
                    'type' => 'checkbox',
                    'label' => esc_html__( 'Display Category', 'lsvr-bluecollar-toolkit' ),
                    'description' => esc_html__( 'Display service post category.', 'lsvr-bluecollar-toolkit' ),
                    'priority' => 90,
                ),

                // Show excerpt
                array(
                    'name' => 'show_excerpt',
                    'type' => 'checkbox',
                    'label' => esc_html__( 'Display Excerpt', 'lsvr-bluecollar-toolkit' ),
                    'description' => esc_html__( 'Display service post excerpt.', 'lsvr-bluecollar-toolkit' ),
                    'priority' => 100,
                ),

                // More label
                array(
                    'name' => 'more_label',
                    'type' => 'text',
                    'label' => esc_html__( 'More Button Label', 'lsvr-bluecollar-toolkit' ),
                    'description' => esc_html__( 'Link to service post archive. Leave blank to hide.', 'lsvr-bluecollar-toolkit' ),
                    'default' => esc_html__( 'More Services', 'lsvr-bluecollar-toolkit' ),
                    'priority' => 200,
                ),

                // ID
                array(
                    'name' => 'id',
                    'type' => 'text',
                    'label' => esc_html__( 'Unique ID', 'lsvr-bluecollar-toolkit' ),
                    'description' => esc_html__( 'You can use this ID to style this specific element with custom CSS, for example.', 'lsvr-bluecollar-toolkit' ),
                    'priority' => 210,
                ),

            ), apply_filters( 'lsvr_bluecollar_services_shortcode_atts', array() ) );
        }

    }
}
?>