<?php
/**
 * LSVR BlueCollar Sidebar Shortcode
 */
if ( ! class_exists( 'Lsvr_Shortcode_Bluecollar_Sidebar' ) ) {
    class Lsvr_Shortcode_Bluecollar_Sidebar {

        public static function shortcode( $atts = array(), $content = null, $tag = '' ) {

            // Merge default atts and received atts
            $args = shortcode_atts(
                array(
                    'sidebar_id' => 'lsvr-bluecollar-default-sidebar',
                    'columns_count' => 3,
                    'id' => '',
                    'className' => '',
                    'editor_view' => false,
                ),
                $atts
            );

            // Check if editor view
            $editor_view = true === $args['editor_view'] || '1' === $args['editor_view'] || 'true' === $args['editor_view'] ? true : false;

            // Element class
            $class_arr = array( 'lsvr-bluecollar-sidebar' );
            if ( true === $editor_view ) {
                array_push( $class_arr, 'lsvr-bluecollar-sidebar--editor-view' );
            }
            if ( ! empty( $args['className'] ) ) {
                array_push( $class_arr, $args['className'] );
            }

            ob_start(); ?>

            <!-- BLUECOLLAR SIDEBAR : begin -->
            <section class="<?php echo esc_attr( implode( ' ', $class_arr ) ); ?>"
                <?php echo ! empty( $args['id'] ) ? ' id="' . esc_attr( $args['id'] ) . '"' : ''; ?>>
                <div class="lsvr-container">
                    <div class="lsvr-bluecollar-sidebar__inner">

                        <?php if ( ! empty( $args['sidebar_id'] ) && is_active_sidebar( $args['sidebar_id'] ) ) : ?>

                            <div class="lsvr-bluecollar-sidebar__list lsvr-bluecollar-sidebar__list--<?php echo ! empty( $args['columns_count'] ) ? esc_attr( $args['columns_count'] ) : 3; ?>-cols">
                                <?php dynamic_sidebar( $args['sidebar_id'] ); ?>
                            </div>

                        <?php endif; ?>

                    </div>
                </div>
            </section>
            <!-- BLUECOLLAR SIDEBAR : end -->

            <?php return ob_get_clean();

        }

        // Shortcode params
        public static function lsvr_shortcode_atts() {
            return array_merge( array(

                // Sidebar ID
                array(
                    'name' => 'sidebar_id',
                    'type' => 'select',
                    'label' => esc_html__( 'Sidebar', 'lsvr-bluecollar-toolkit' ),
                    'description' => esc_html__( 'Choose which sidebar will be used to create this section. You can manage custom sidebars under Customizer / Custom Sidebars and populate them with widgets under Appearance / Widgets.', 'lsvr-bluecollar-toolkit' ),
                    'choices' => lsvr_bluecollar_toolkit_get_sidebars(),
                    'default' => 'lsvr-bluecollar-default-sidebar',
                    'priority' => 10,
                ),

                // Columns count
                array(
                    'name' => 'columns_count',
                    'type' => 'select',
                    'label' => esc_html__( 'Number of Columns', 'lsvr-bluecollar-toolkit' ),
                    'description' => esc_html__( 'How many columns should be used to display the widgets.', 'lsvr-bluecollar-toolkit' ),
                    'choices' => array( 1 => 1, 2 => 2, 3 => 3, 4 => 4 ),
                    'default' => 3,
                    'priority' => 20,
                ),

                // ID
                array(
                    'name' => 'id',
                    'type' => 'text',
                    'label' => esc_html__( 'Unique ID', 'lsvr-bluecollar-toolkit' ),
                    'description' => esc_html__( 'You can use this ID to style this specific element with custom CSS, for example.', 'lsvr-bluecollar-toolkit' ),
                    'priority' => 30,
                ),

            ), apply_filters( 'lsvr_bluecollar_sidebar_shortcode_atts', array() ) );
        }

    }
}
?>