<?php
/**
 * LSVR BlueCollar Testimonials Shortcode
 */
if ( ! class_exists( 'Lsvr_Shortcode_Bluecollar_Testimonials' ) ) {
    class Lsvr_Shortcode_Bluecollar_Testimonials {

        public static function shortcode( $atts = array(), $content = null, $tag = '' ) {

            // Merge default atts and received atts
            $args = shortcode_atts(
                array(
                    'id' => '',
                    'title' => '',
                    'limit' => 4,
                    'order' => '',
                    'columns' => 2,
                    'background_image' => '',
                    'colored_background' => '',
                    'centered_title' => '',
                    'enable_masonry' => '',
                    'more_label' => '',
                    'className' => '',
                    'editor_view' => false,
                ),
                $atts
            );

            // Prepare grid and cols classes
            $grid_class = 'lsvr-grid lsvr-grid--' . $args['columns'] . '-cols';
            $grid_class .= (int) $args['columns'] > 1 ? ' lsvr-grid--md-2-cols' : '';
            $col_class = 'lsvr-grid__col lsvr-grid__col--span-' . esc_attr( 12 / (int) $args['columns'] );
            $col_class .= (int) $args['columns'] > 1 ? ' lsvr-grid__col--md-span-6' : '';

            // Check if editor view
            $editor_view = true === $args['editor_view'] || '1' === $args['editor_view'] || 'true' === $args['editor_view'] ? true : false;

            // Enable colored background
            $colored_background = true === $args['colored_background'] || '1' === $args['colored_background'] || 'true' === $args['colored_background'] ? true : false;

            // Enable centered title
            $centered_title = true === $args['centered_title'] || '1' === $args['centered_title'] || 'true' === $args['centered_title'] ? true : false;

            // Enable masonry
            $enable_masonry = true === $args['enable_masonry'] || '1' === $args['enable_masonry'] || 'true' === $args['enable_masonry'] ? true : false;

            // Background image
            if ( ( ! empty( $args['background_image'] ) && is_numeric( $args['background_image'] ) && (int) $args['background_image'] > 0 )
                || ( is_array( $args['background_image'] ) && ! empty( $args['background_image']['id'] ) ) ) {

                $image_id = is_array( $args['background_image'] ) && ! empty( $args['background_image']['id'] ) ? (int) $args['background_image']['id'] : (int) $args['background_image'];
                $image_data = wp_get_attachment_image_src( $image_id, 'full' );

                if ( ! empty( $image_data[0] ) ) {
                    $background_url = $image_data[0];
                }

            } elseif ( ! empty( $args['background_image'] ) && ! is_array( $args['background_image'] ) ) {
                $background_url = $args['background_image'];
            }

            // Element class
            $class_arr = array( 'lsvr-bluecollar-testimonials' );
            if ( true === $editor_view ) {
                array_push( $class_arr, 'lsvr-bluecollar-testimonials--editor-view' );
            }
            if ( true === $colored_background ) {
                array_push( $class_arr, 'lsvr-bluecollar-testimonials--has-background-color' );
            }
            if ( ! empty( $background_url ) ) {
                array_push( $class_arr, 'lsvr-bluecollar-testimonials--has-background-image' );
            }
            if ( true === $enable_masonry ) {
                array_push( $class_arr, 'lsvr-bluecollar-testimonials--is-masonry' );
            }
            if ( ! empty( $args['className'] ) ) {
                array_push( $class_arr, $args['className'] );
            }

            // Prepare query
            $limit = 0 === (int) $args['limit'] ? 1000 : (int) $args['limit'];
            $query_args = array(
                'posts_per_page' => $limit,
                'post_type' => 'lsvr_testimonial',
            );

            // Set order
            if ( ! empty( $args['order'] ) && 'default' !== $args['order'] ) {
                if ( 'date_desc' == $args['order'] ) {
                    $query_args['orderby'] = 'date';
                    $query_args['order'] = 'DESC';
                }
                elseif ( 'date_asc' == $args['order'] ) {
                    $query_args['orderby'] = 'date';
                    $query_args['order'] = 'ASC';
                }
                elseif ( 'title_asc' == $args['order'] ) {
                    $query_args['orderby'] = 'title';
                    $query_args['order'] = 'ASC';
                }
                elseif ( 'title_desc' == $args['order'] ) {
                    $query_args['orderby'] = 'title';
                    $query_args['order'] = 'DESC';
                }
                elseif ( 'random' == $args['order'] ) {
                    $query_args['orderby'] = 'rand';
                }
            }

            // Get posts
            $posts = get_posts( $query_args );

            ob_start(); ?>

            <!-- BLUECOLLAR TESTIMONIALS : begin -->
            <section class="<?php echo esc_attr( implode( ' ', $class_arr ) ); ?>"
                <?php echo ! empty( $args['id'] ) ? ' id="' . esc_attr( $args['id'] ) . '"' : ''; ?>>
                <div class="lsvr-bluecollar-testimonials__bg"
                    <?php if ( ! empty( $background_url ) ) { echo ' style="background-image: url( \'' . esc_url( $background_url ) . '\');"'; } ?>>
                    <div class="lsvr-bluecollar-testimonials__inner">
                        <div class="lsvr-container">
                            <div class="lsvr-bluecollar-testimonials__content">

                                <?php if ( ! empty( $args['title'] ) ) : ?>
                                    <header class="lsvr-bluecollar-testimonials__header">

                                         <?php if ( ! empty( $args['title'] ) && true === $centered_title ) : ?>

                                            <h1 class="lsvr-bluecollar-testimonials__title lsvr-bluecollar-testimonials__title--centered">
                                                <?php echo wp_kses( $args['title'], array(
                                                    'a' => array(
                                                        'href' => '',
                                                    ),
                                                    'br' => array(),
                                                    'span' => array(
                                                        'class' => array(),
                                                        'style' => array(),
                                                    ),
                                                    'strong' => array(),
                                                ) ); ?>
                                            </h1>

                                        <?php elseif ( ! empty( $args['title'] ) ) : ?>

                                            <h2 class="lsvr-bluecollar-testimonials__title">
                                                <?php echo wp_kses( $args['title'], array(
                                                    'a' => array(
                                                        'href' => '',
                                                    ),
                                                    'br' => array(),
                                                    'span' => array(
                                                        'class' => array(),
                                                        'style' => array(),
                                                    ),
                                                    'strong' => array(),
                                                ) ); ?>
                                            </h2>

                                        <?php endif; ?>

                                    </header>
                                <?php endif; ?>

                                <?php if ( ! empty( $posts ) ) : ?>

                                    <div class="<?php echo esc_attr( $grid_class ); ?> lsvr-bluecollar-testimonials__list">

                                        <?php foreach ( $posts as $post ) : ?>

                                            <div class="<?php echo esc_attr( $col_class ); ?> lsvr-bluecollar-testimonials__item">

                                                <div <?php post_class( 'lsvr-bluecollar-testimonials__post', $post->ID ); ?>>
                                                    <div class="lsvr-bluecollar-testimonials__post-inner">

                                                        <div class="lsvr-bluecollar-testimonials__post-content-wrapper">

                                                            <blockquote class="lsvr-bluecollar-testimonials__post-quote">

                                                                <?php echo has_blocks( $post->ID ) ? $post->post_content : wpautop( $post->post_content ); ?>

                                                                <footer class="lsvr-bluecollar-testimonials__post-footer<?php if ( has_post_thumbnail( $post->ID ) ) { echo ' lsvr-bluecollar-testimonials__post-footer--has-thumbnail'; } ?>">

                                                                    <?php if ( has_post_thumbnail( $post->ID ) ) : ?>
                                                                        <p class="lsvr-bluecollar-testimonials__post-thumbnail">
                                                                            <a href="<?php echo esc_url( get_the_permalink( $post->ID ) ); ?>" class="lsvr-bluecollar-testimonials__post-thumbnail-link">
                                                                                <?php echo get_the_post_thumbnail( $post->ID, 'thumbnail' ); ?>
                                                                            </a>
                                                                        </p>
                                                                    <?php endif; ?>

                                                                    <cite class="lsvr-bluecollar-testimonials__post-title">

                                                                        <a href="<?php echo esc_url( get_the_permalink( $post->ID ) ); ?>" class="lsvr-bluecollar-testimonials__post-title-link" rel="bookmark">
                                                                            <?php echo esc_html( $post->post_title ); ?>
                                                                        </a>

                                                                        <?php if ( ! empty( get_post_meta( $post->ID, 'lsvr_testimonial_author_description', true ) ) ) : ?>

                                                                            <span class="lsvr-bluecollar-testimonials__post-title-description">
                                                                                <?php echo esc_html( get_post_meta( $post->ID, 'lsvr_testimonial_author_description', true ) ); ?>
                                                                            </span>

                                                                        <?php endif; ?>

                                                                    </cite>

                                                                </footer>

                                                            </blockquote>

                                                        </div>

                                                    </div>
                                                </div>

                                            </div>

                                        <?php endforeach; wp_reset_postdata(); ?>

                                    </div>

                                <?php else : ?>

                                    <p class="c-alert-message"><?php esc_html_e( 'There are no testimonials', 'lsvr-bluecollar-toolkit' ); ?></p>

                                <?php endif; ?>

                                <?php if ( ! empty( $args[ 'more_label' ] ) ) : ?>

                                    <footer class="lsvr-bluecollar-testimonials__footer">

                                        <p class="lsvr-bluecollar-testimonials__more">
                                            <a href="<?php echo esc_url( get_post_type_archive_link( 'lsvr_testimonial' ) ); ?>" class="c-button lsvr-bluecollar-testimonials__more-link"><?php echo esc_html( $args[ 'more_label' ] ); ?></a>
                                        </p>

                                    </footer>

                                <?php endif; ?>

                            </div>
                        </div>
                    </div>
                </div>
            </section>
            <!-- BLUECOLLAR TESTIMONIALS : end -->

            <?php return ob_get_clean();

        }

        // Shortcode params
        public static function lsvr_shortcode_atts() {
            return array_merge( array(

                // Title
                array(
                    'name' => 'title',
                    'type' => 'text',
                    'label' => esc_html__( 'Title', 'lsvr-bluecollar-toolkit' ),
                    'default' => esc_html__( 'Testimonials', 'lsvr-bluecollar-toolkit' ),
                    'priority' => 10,
                ),

                // Limit
                array(
                    'name' => 'limit',
                    'type' => 'select',
                    'label' => esc_html__( 'Limit', 'lsvr-bluecollar-toolkit' ),
                    'description' => esc_html__( 'How many testimonial posts should be displayed.', 'lsvr-bluecollar-toolkit' ),
                    'choices' => array( 0 => esc_html__( 'All', 'lsvr-bluecollar-toolkit' ) ) + range( 0, 20, 1 ),
                    'default' => 4,
                    'priority' => 30,
                ),

                // Order
                array(
                    'name' => 'order',
                    'type' => 'select',
                    'label' => esc_html__( 'Order', 'lsvr-bluecollar-toolkit' ),
                    'description' => esc_html__( 'Order of testimonial posts.', 'lsvr-bluecollar-toolkit' ),
                    'choices' => array(
                        'default' => esc_html__( 'Default', 'lsvr-bluecollar-toolkit' ),
                        'date_desc' => esc_html__( 'By date, newest first', 'lsvr-bluecollar-toolkit' ),
                        'date_asc' => esc_html__( 'By date, oldest first', 'lsvr-bluecollar-toolkit' ),
                        'title_asc' => esc_html__( 'By title, ascending', 'lsvr-bluecollar-toolkit' ),
                        'title_desc' => esc_html__( 'By title, descending', 'lsvr-bluecollar-toolkit' ),
                        'random' => esc_html__( 'Random', 'lsvr-bluecollar-toolkit' ),
                    ),
                    'default' => 'default',
                    'priority' => 35,
                ),

                // Columns count
                array(
                    'name' => 'columns',
                    'type' => 'select',
                    'label' => esc_html__( 'Number of Columns', 'lsvr-bluecollar-toolkit' ),
                    'description' => esc_html__( 'How many columns should be used to display testimonial posts.', 'lsvr-bluecollar-toolkit' ),
                    'choices' => array( 1 => 1, 2 => 2, 3 => 3, 4 => 4 ),
                    'default' => 2,
                    'priority' => 40,
                ),

                // Background image
                array(
                    'name' => 'background_image',
                    'type' => 'image',
                    'label' => esc_html__( 'Background Image', 'lsvr-bluecollar-toolkit' ),
                    'description' => esc_html__( 'Background image of this section.', 'lsvr-bluecollar-toolkit' ),
                    'priority' => 50,
                ),

                // Colored background
                array(
                    'name' => 'colored_background',
                    'type' => 'checkbox',
                    'label' => esc_html__( 'Display Colored Background', 'lsvr-bluecollar-toolkit' ),
                    'description' => esc_html__( 'Make this section stand out. If you are using background image, it will use color overlay.', 'lsvr-bluecollar-toolkit' ),
                    'priority' => 55,
                ),

                // Centered title
                array(
                    'name' => 'centered_title',
                    'type' => 'checkbox',
                    'label' => esc_html__( 'Centered Title', 'lsvr-bluecollar-toolkit' ),
                    'description' => esc_html__( 'Center the section title.', 'lsvr-bluecollar-toolkit' ),
                    'priority' => 60,
                ),

                // Enable masonry
                array(
                    'name' => 'enable_masonry',
                    'type' => 'checkbox',
                    'label' => esc_html__( 'Enable Masonry', 'lsvr-bluecollar-toolkit' ),
                    'description' => esc_html__( 'Display testimonial posts grid using masonry layout.', 'lsvr-bluecollar-toolkit' ),
                    'priority' => 90,
                ),

                // More label
                array(
                    'name' => 'more_label',
                    'type' => 'text',
                    'label' => esc_html__( 'More Button Label', 'lsvr-bluecollar-toolkit' ),
                    'description' => esc_html__( 'Link to testimonial post archive. Leave blank to hide.', 'lsvr-bluecollar-toolkit' ),
                    'default' => esc_html__( 'More Testimonials', 'lsvr-bluecollar-toolkit' ),
                    'priority' => 200,
                ),

                // ID
                array(
                    'name' => 'id',
                    'type' => 'text',
                    'label' => esc_html__( 'Unique ID', 'lsvr-bluecollar-toolkit' ),
                    'description' => esc_html__( 'You can use this ID to style this specific element with custom CSS, for example.', 'lsvr-bluecollar-toolkit' ),
                    'priority' => 210,
                ),

            ), apply_filters( 'lsvr_bluecollar_testimonials_shortcode_atts', array() ) );
        }

    }
}
?>