<?php
/**
 * Plugin Name: LSVR BlueCollar Theme Toolkit
 * Description: Adds theme-specific functionality
 * Version: 1.3.0
 * Author: LSVRthemes
 * Author URI: http://themeforest.net/user/LSVRthemes/portfolio
 * Text Domain: lsvr-bluecollar-toolkit
 * Domain Path: /languages
 * License: http://themeforest.net/licenses
 * License URI: http://themeforest.net/licenses
*/

// Include additional functions and classes
require_once( ABSPATH . 'wp-admin/includes/plugin.php' );
require_once( 'inc/core-functions.php' );
require_once( 'inc/frontend-functions.php' );
require_once( 'inc/blocks-config.php' );

// Load textdomain
load_plugin_textdomain( 'lsvr-bluecollar-toolkit', false, plugin_basename( dirname( __FILE__ ) ) . '/languages/' );

// Register shortcodes
add_action( 'init', 'lsvr_bluecollar_toolkit_register_shortcodes' );
if ( ! function_exists( 'lsvr_bluecollar_toolkit_register_shortcodes' ) ) {
	function lsvr_bluecollar_toolkit_register_shortcodes() {

    	// CTA
		require_once( 'inc/classes/shortcodes/lsvr-shortcode-bluecollar-cta.php' );
		if ( class_exists( 'Lsvr_Shortcode_Bluecollar_CTA' ) ) {
			add_shortcode( 'lsvr_bluecollar_cta', array( 'Lsvr_Shortcode_Bluecollar_CTA', 'shortcode' ) );
		}

    	// FAQ
		require_once( 'inc/classes/shortcodes/lsvr-shortcode-bluecollar-faq.php' );
		if ( class_exists( 'Lsvr_Shortcode_Bluecollar_FAQ' ) ) {
			add_shortcode( 'lsvr_bluecollar_faq', array( 'Lsvr_Shortcode_Bluecollar_FAQ', 'shortcode' ) );
		}

    	// Features
		require_once( 'inc/classes/shortcodes/lsvr-shortcode-bluecollar-features.php' );
		if ( class_exists( 'Lsvr_Shortcode_Bluecollar_Features' ) ) {
			add_shortcode( 'lsvr_bluecollar_features', array( 'Lsvr_Shortcode_Bluecollar_Features', 'shortcode' ) );
		}

    	// Intro
		require_once( 'inc/classes/shortcodes/lsvr-shortcode-bluecollar-intro.php' );
		if ( class_exists( 'Lsvr_Shortcode_Bluecollar_Intro' ) ) {
			add_shortcode( 'lsvr_bluecollar_intro', array( 'Lsvr_Shortcode_Bluecollar_Intro', 'shortcode' ) );
		}

    	// Posts
		require_once( 'inc/classes/shortcodes/lsvr-shortcode-bluecollar-posts.php' );
		if ( class_exists( 'Lsvr_Shortcode_Bluecollar_Posts' ) ) {
			add_shortcode( 'lsvr_bluecollar_posts', array( 'Lsvr_Shortcode_Bluecollar_Posts', 'shortcode' ) );
		}

    	// Projects
		require_once( 'inc/classes/shortcodes/lsvr-shortcode-bluecollar-projects.php' );
		if ( class_exists( 'Lsvr_Shortcode_Bluecollar_Projects' ) ) {
			add_shortcode( 'lsvr_bluecollar_projects', array( 'Lsvr_Shortcode_Bluecollar_Projects', 'shortcode' ) );
		}

    	// Services
		require_once( 'inc/classes/shortcodes/lsvr-shortcode-bluecollar-services.php' );
		if ( class_exists( 'Lsvr_Shortcode_Bluecollar_Services' ) ) {
			add_shortcode( 'lsvr_bluecollar_services', array( 'Lsvr_Shortcode_Bluecollar_Services', 'shortcode' ) );
		}

    	// Sidebar
		require_once( 'inc/classes/shortcodes/lsvr-shortcode-bluecollar-sidebar.php' );
		if ( class_exists( 'Lsvr_Shortcode_Bluecollar_Sidebar' ) ) {
			add_shortcode( 'lsvr_bluecollar_sidebar', array( 'Lsvr_Shortcode_Bluecollar_Sidebar', 'shortcode' ) );
		}

    	// Testimonials
		require_once( 'inc/classes/shortcodes/lsvr-shortcode-bluecollar-testimonials.php' );
		if ( class_exists( 'Lsvr_Shortcode_Bluecollar_Testimonials' ) ) {
			add_shortcode( 'lsvr_bluecollar_testimonials', array( 'Lsvr_Shortcode_Bluecollar_Testimonials', 'shortcode' ) );
		}

	}
}

?>