<?php
add_action('after_setup_theme', 'decorators_bunch_theme_setup');
function decorators_bunch_theme_setup()
{
	global $wp_version;
	if(!defined('DECORATORS_VERSION')) define('DECORATORS_VERSION', '1.0');
	if( !defined( 'DECORATORS_ROOT' ) ) define('DECORATORS_ROOT', get_template_directory().'/');
	if( !defined( 'DECORATORS_URL' ) ) define('DECORATORS_URL', get_template_directory_uri().'/');	
	if( !defined( 'KC_LICENSE' ) ) define('KC_LICENSE', 'l483kg4m-jxbv-ju7k-or7h-yhgd-q3jl1ec3fqyi');
	include_once get_template_directory() . '/includes/loader.php';
	
	
	load_theme_textdomain('decorators', get_template_directory() . '/languages');
	
	//ADD THUMBNAIL SUPPORT
	add_theme_support('post-thumbnails');
	add_theme_support('woocommerce');
	add_theme_support('automatic-feed-links'); //Enables post and comment RSS feed links to head.
	add_theme_support('widgets'); //Add widgets and sidebar support
	add_theme_support( "title-tag" );
	add_theme_support( 'wp-block-styles' );
	add_theme_support( 'align-wide' );
	add_theme_support( 'editor-styles' );
	/*
	 * Switch default core markup for search form, comment form, and comments
	 * to output valid HTML5.
	 */
	add_theme_support( 'html5', array(
		'search-form', 'comment-form', 'comment-list', 'gallery', 'caption'
	) );
	/** Register wp_nav_menus */
	if(function_exists('register_nav_menu'))
	{
		register_nav_menus(
			array(
				/** Register Main Menu location header */
				'main_menu' => esc_html__('Main Menu', 'decorators'),
				'footer_menu' => esc_html__('Footer Menu', 'decorators'),
			)
		);
	}
	if ( ! isset( $content_width ) ) $content_width = 960;
	add_image_size( 'decorators_370x235', 370, 235, true ); // 370x235 Project With Text'
	add_image_size( 'decorators_370x210', 370, 210, true ); // 370x210 Services Featured'
	add_image_size( 'decorators_270x245', 270, 245, true ); // 270x245 Services Recent Work'
	add_image_size( 'decorators_480x480', 480, 480, true ); // 480x480 Project 4 Column'
	add_image_size( 'decorators_1170x475', 1170, 475, true ); // 1170x475 Blog Page'
	add_image_size( 'decorators_65x65', 65, 65, true ); // 65x65 Recent Posts'
	add_image_size( 'decorators_60x60', 60, 60, true ); // 60x60 Recent Work'
	add_image_size( 'decorators_75x75', 75, 75, true ); // 75x75 Testimonials'
}

function decorators_gutenberg_editor_palette_styles() {
    add_theme_support( 'editor-color-palette', array(
        array(
            'name' => esc_html__( 'strong yellow', 'decorators' ),
            'slug' => 'strong-yellow',
            'color' => '#f7bd00',
        ),
        array(
            'name' => esc_html__( 'strong white', 'decorators' ),
            'slug' => 'strong-white',
            'color' => '#fff',
        ),
		array(
            'name' => esc_html__( 'light black', 'decorators' ),
            'slug' => 'light-black',
            'color' => '#242424',
        ),
        array(
            'name' => esc_html__( 'very light gray', 'decorators' ),
            'slug' => 'very-light-gray',
            'color' => '#797979',
        ),
        array(
            'name' => esc_html__( 'very dark black', 'decorators' ),
            'slug' => 'very-dark-black',
            'color' => '#000000',
        ),
    ) );
	
	add_theme_support( 'editor-font-sizes', array(
		array(
			'name' => esc_html__( 'Small', 'decorators' ),
			'size' => 10,
			'slug' => 'small'
		),
		array(
			'name' => esc_html__( 'Normal', 'decorators' ),
			'size' => 15,
			'slug' => 'normal'
		),
		array(
			'name' => esc_html__( 'Large', 'decorators' ),
			'size' => 24,
			'slug' => 'large'
		),
		array(
			'name' => esc_html__( 'Huge', 'decorators' ),
			'size' => 36,
			'slug' => 'huge'
		)
	) );
	
}
add_action( 'after_setup_theme', 'decorators_gutenberg_editor_palette_styles' );

function decorators_bunch_widget_init()
{
	global $wp_registered_sidebars;
	$theme_options = _WSH()->option();
	
	register_sidebar(array(
	  'name' => esc_html__( 'Default Sidebar', 'decorators' ),
	  'id' => 'default-sidebar',
	  'description' => esc_html__( 'Widgets in this area will be shown on the right-hand side.', 'decorators' ),
	  'before_widget'=>'<div id="%1$s" class="widget sidebar-widget %2$s">',
	  'after_widget'=>'</div>',
	  'before_title' => '<div class="sidebar-title"><h3>',
	  'after_title' => '</h3></div>'
	));
	register_sidebar(array(
	  'name' => esc_html__( 'Footer Sidebar', 'decorators' ),
	  'id' => 'footer-sidebar',
	  'description' => esc_html__( 'Widgets in this area will be shown in Footer Area.', 'decorators' ),
	  'before_widget'=>'<div id="%1$s" class="col-md-3 col-sm-6 col-xs-12 footer-column footer-widget %2$s">',
	  'after_widget'=>'</div>',
	  'before_title' => '<h2>',
	  'after_title' => '</h2>'
	));
	
	register_sidebar(array(
	  'name' => esc_html__( 'Blog Listing', 'decorators' ),
	  'id' => 'blog-sidebar',
	  'description' => esc_html__( 'Widgets in this area will be shown on the right-hand side.', 'decorators' ),
	  'before_widget'=>'<div id="%1$s" class="widget sidebar-widget %2$s">',
	  'after_widget'=>'</div>',
	  'before_title' => '<div class="sidebar-title"><h3>',
	  'after_title' => '</h3></div>'
	));
	if( !is_object( _WSH() )  )  return;
	$sidebars = decorators_set(decorators_set( $theme_options, 'dynamic_sidebar' ) , 'dynamic_sidebar' ); 
	foreach( array_filter((array)$sidebars) as $sidebar)
	{
		if(decorators_set($sidebar , 'topcopy')) continue ;
		
		$name = decorators_set( $sidebar, 'sidebar_name' );
		
		if( ! $name ) continue;
		$slug = decorators_bunch_slug( $name ) ;
		
		register_sidebar( array(
			'name' => $name,
			'id' =>  sanitize_title( $slug ),
			'before_widget' => '<div id="%1$s" class="widget sidebar-widget %2$s">',
			'after_widget' => "</div>",
			'before_title' => '<div class="sidebar-title"><h3>',
			'after_title' => '</h3></div>',
		) );		
	}
	
	update_option('wp_registered_sidebars' , $wp_registered_sidebars) ;
}
add_action( 'widgets_init', 'decorators_bunch_widget_init' );
// Update items in cart via AJAX
function decorators_load_head_scripts() {
    $options = _WSH()->option();
	if ( !is_admin() ) {
	$protocol = is_ssl() ? 'https://' : 'http://';
	if(decorators_set($options, 'map_api_key')){
	$map_path = '?key='.decorators_set($options, 'map_api_key');
	wp_enqueue_script( 'decorators_map_api', $protocol.'maps.google.com/maps/api/js'.$map_path, array(), false, false );
	wp_enqueue_script( 'jquery-googlemap', get_template_directory_uri().'/js/jquery.gmap.js', array(), false, false );
	}
	}
    }
    add_action( 'wp_enqueue_scripts', 'decorators_load_head_scripts' );
//global variables
function decorators_bunch_global_variable() {
    global $wp_query;
}

function decorators_enqueue_scripts() {
	$theme_options = _WSH()->option();
	$maincolor = str_replace( '#', '' , decorators_set( $theme_options, 'main_color_scheme', 'fc721e' ) );
    //styles
	wp_enqueue_style( 'bootstrap', get_template_directory_uri() . '/css/bootstrap.css' );
	wp_enqueue_style( 'gui', get_template_directory_uri() . '/css/gui.css' );
	wp_enqueue_style( 'fontawesom', get_template_directory_uri() . '/css/font-awesome.css' );
	wp_enqueue_style( 'flaticon', get_template_directory_uri() . '/css/flaticon.css' );
	wp_enqueue_style( 'animate', get_template_directory_uri() . '/css/animate.css' );
	wp_enqueue_style( 'owl-theme', get_template_directory_uri() . '/css/owl.css' );
	wp_enqueue_style( 'fancybox', get_template_directory_uri() . '/css/jquery.fancybox.css' );
	wp_enqueue_style( 'mCustomScrollbar', get_template_directory_uri() . '/css/jquery.mCustomScrollbar.min.css' );
	wp_enqueue_style( 'bootstrap-touchspin', get_template_directory_uri() . '/css/jquery.bootstrap-touchspin.css' );
	wp_enqueue_style( 'decorators_main-style', get_stylesheet_uri() );
	if(class_exists('woocommerce')) wp_enqueue_style( 'decorators_rwoocommerce', get_template_directory_uri() . '/css/woocommerce.css' );
	wp_enqueue_style( 'decorators_custom-style', get_template_directory_uri() . '/css/custom.css' );
	wp_enqueue_style( 'decorators_tut-style', get_template_directory_uri() . '/css/tut.css' );
	wp_enqueue_style( 'decorators_gutenberg', get_template_directory_uri() . '/css/gutenberg.css' );
	wp_enqueue_style( 'decorators_responsive', get_template_directory_uri() . '/css/responsive.css' );
	wp_enqueue_style( 'decorators-main-color', get_template_directory_uri() . '/css/color.php?main_color='.$maincolor );
	wp_enqueue_style( 'decorators-color-panel', get_template_directory_uri() . '/css/color-panel.css' );
	
	
    //scripts
	wp_enqueue_script( 'jquery-ui-core' );
	wp_enqueue_script( 'bootstrap', get_template_directory_uri().'/js/bootstrap.min.js', array(), false, true );
	wp_enqueue_script( 'mCustomScrollbar', get_template_directory_uri().'/js/jquery.mCustomScrollbar.concat.min.js', array(), false, true );
	wp_enqueue_script( 'fancybox', get_template_directory_uri().'/js/jquery.fancybox.pack.js', array(), false, true );
	wp_enqueue_script( 'fancybox-media', get_template_directory_uri().'/js/jquery.fancybox-media.js', array(), false, true );
	wp_enqueue_script( 'isotope', get_template_directory_uri().'/js/isotope.js', array(), false, true );
	wp_enqueue_script( 'owl', get_template_directory_uri().'/js/owl.js', array(), false, true );
	wp_enqueue_script( 'mixitup', get_template_directory_uri().'/js/mixitup.js', array(), false, true );
	wp_enqueue_script( 'wow', get_template_directory_uri().'/js/wow.js', array(), false, true );
	wp_enqueue_script( 'decorators_main_script', get_template_directory_uri().'/js/script.js', array(), false, true );
	if( is_singular() ) wp_enqueue_script('comment-reply');
	
}
add_action( 'wp_enqueue_scripts', 'decorators_enqueue_scripts' );

/*-------------------------------------------------------------*/
function decorators_theme_slug_fonts_url() {
    $fonts_url = '';
 
    /* Translators: If there are characters in your language that are not
    * supported by Lora, translate this to 'off'. Do not translate
    * into your own language.
    */
    $lato = _x( 'on', 'Lato font: on or off', 'decorators' );
	$montserrat = _x( 'on', 'Montserrat font: on or off', 'decorators' );
	$oswald = _x( 'on', 'Oswald font: on or off', 'decorators' );
	
    /* Translators: If there are characters in your language that are not
    * supported by Open Sans, translate this to 'off'. Do not translate
    * into your own language.
    */
    $open_sans = _x( 'on', 'Open Sans font: on or off', 'decorators' );
 
    if ( 'off' !== $lato || 'off' !== $montserrat || 'off' !== $oswald ) {
        $font_families = array();
 
        if ( 'off' !== $lato ) {
            $font_families[] = 'Lato:100,100i,300,300i,400,400i,700,700i,900,900i';
        }
		
		if ( 'off' !== $montserrat ) {
            $font_families[] = 'Montserrat:400,700|Open+Sans:300,300i,400,400i,600,600i,700,700i';
        }
		
		if ( 'off' !== $oswald ) {
            $font_families[] = 'Oswald:300,400,700';
        }
 
        $query_args = array(
            'family' => urlencode( implode( '|', $font_families ) ),
            'subset' => urlencode( 'latin,latin-ext' ),
        );
 
        $fonts_url = add_query_arg( $query_args, 'https://fonts.googleapis.com/css' );
    }
 
    return esc_url_raw( $fonts_url );
}
function decorators_theme_slug_scripts_styles() {
    wp_enqueue_style( 'decorators-theme-slug-fonts', decorators_theme_slug_fonts_url(), array(), null );
}
add_action( 'wp_enqueue_scripts', 'decorators_theme_slug_scripts_styles' );
/*---------------------------------------------------------------------*/
function decorators_add_editor_styles() {
    add_editor_style( 'editor-style.css' );
}
add_action( 'admin_init', 'decorators_add_editor_styles' );
/**
 * WooCommerce Extra Feature
 * --------------------------
 *
 * Change number of related products on product page
 * Set your own value for 'posts_per_page'
 *
 */ 
function decorators_woo_related_products_limit() {
  global $product;
	
	$args['posts_per_page'] = 6;
	return $args;
}
add_filter( 'woocommerce_output_related_products_args', 'decorators_jk_related_products_args' );
  function decorators_jk_related_products_args( $args ) {
	$args['posts_per_page'] = 3; // 4 related products
	$args['columns'] = 3; // arranged in 2 columns
	return $args;
}