<?php
ob_start() ;?>

<!--About Us Section-->
<section class="about-us-section">
    <div class="auto-container">
        <div class="row clearfix">
            
            <!--Text Column -->
            <div class="column text-column col-md-6 col-sm-12 col-xs-12">
                <h2><?php echo wp_kses_post($title);?><a href="<?php echo esc_url($sub_title_link);?>"><?php echo wp_kses_post($sub_title);?></a></h2>
                <div class="inner-box">
                     <div class="text"><?php echo wp_kses_post($text);?></div>
                     <div class="signature-image"><img src="<?php echo esc_url(wp_get_attachment_url($sign_img))?>" alt="<?php esc_attr_e('image', 'decorators');?>"></div>
                     <div class="about-owner">
                        <h4><?php echo wp_kses_post($author_title);?> <span class="designation"><?php echo wp_kses_post($designation);?></span></h4>
                        <div class="company-title"><?php echo wp_kses_post($company_title);?></div>
                     </div>
                </div>
            </div>
            
            <!--Column-->
            <div class="column image-column col-md-6 col-sm-12 col-xs-12">
                <article class="inner-box wow fadeInRight" data-wow-delay="0ms" data-wow-duration="1500ms">
                    <figure class="image-box video-box">
                        <img src="<?php echo esc_url(wp_get_attachment_url($video_img))?>" alt="<?php esc_attr_e('image', 'decorators');?>">
                        <a href="<?php echo esc_url($video_link);?>" class="lightbox-image video-link"><div class="icon"><span class="flaticon-play-button-5"></span></div></a>
                    </figure>
                </article>
            </div>
            
        </div>
        
        <!--Our Services-->
        <div class="our-services">
            <div class="row clearfix">
                <?php $skills_array = (array)json_decode(urldecode($services));
					if( $skills_array && is_array($skills_array) ): 
					foreach( (array)$skills_array as $value ):
				?>
                <!--service-block-one-->
                <div class="service-block-one col-md-4 col-sm-6 col-xs-12">
                    <div class="inner-box wow fadeIn" data-wow-delay="0ms" data-wow-duration="1500ms">
                        <!--icon-block-->
                        <div class="icon-box">
                            <span class="<?php echo esc_attr(decorators_set( $value, 'icon' ));?>"></span>
                        </div>
                        <h3><?php echo wp_kses_post(decorators_set( $value, 'title' )); ?></h3>
                        <div class="category"><a href="<?php echo esc_url(decorators_set( $value, 'link' )); ?>"><?php echo wp_kses_post(decorators_set( $value, 'designation' )); ?></a></div>
                        <div class="text"><?php echo wp_kses_post(decorators_set( $value, 'text' )); ?>.</div>
                    </div>
                </div>
                <?php endforeach; endif;?>
                
            </div>
        </div>
        
    </div>
</section>

<?php
	$output = ob_get_contents(); 
   ob_end_clean(); 
   return $output ; ?>
   