<?php
ob_start() ;?>

<!--welcome-section-->
<section class="welcome-section">
    <div class="auto-container">
        <div class="row clearfix">
            <!--welcome-column-->
            <div class="col-md-6 col-sm-12 col-xs-12 welcome-column">
                <!--inner-content-->
                <div class="inner-content wow fadeInLeft" data-wow-delay="0ms" data-wow-duration="1500ms">
                    <h2><?php echo wp_kses_post($title);?></h2>
                    <h3><?php echo wp_kses_post($sub_title);?><span><?php echo wp_kses_post($color_sub_title);?></span></h3>
                    
                    <div class="text"><?php echo wp_kses_post($text);?></div>
                    <figure class="signature">
                        <img src="<?php echo esc_url(wp_get_attachment_url($signature_img));?>" alt="<?php esc_attr_e('image', 'decorators');?>" />
                    </figure>
                    
                    <!--author-title-->
                    <div class="author-title">
                        <div class="author-info"><?php echo wp_kses_post($author_info);?><span><?php echo wp_kses_post($designation);?></span></div>
                        <div class="author-designation"><?php echo wp_kses_post($company_title);?></div>
                    </div>
                </div>
            </div>
            
            <!--service-column-->
            <div class="col-md-6 col-sm-12 col-xs-12 service-column">
                <!--service-block-one-->
                <?php $skills_array = (array)json_decode(urldecode($services));
					if( $skills_array && is_array($skills_array) ): 
					foreach( (array)$skills_array as $value ):
				?>
                <div class="service-block-one">
                    <div class="inner-box">
                        <!--icon-block-->
                        <div class="icon-box">
                            <span class="<?php echo esc_attr(decorators_set( $value, 'icon' ));?>"></span>
                        </div>
                        <h3><?php echo wp_kses_post(decorators_set( $value, 'title' )); ?></h3>
                        <div class="category"><a href="<?php echo esc_url(decorators_set( $value, 'link' )); ?>"><?php echo wp_kses_post(decorators_set( $value, 'designation' )); ?></a></div>
                        <div class="text"><?php echo wp_kses_post(decorators_set( $value, 'text' )); ?></div>
                    </div>
                </div>
                <?php endforeach; endif;?>
            </div>
        </div>
    </div>
</section>

<?php
	$output = ob_get_contents(); 
   ob_end_clean(); 
   return $output ; ?>
   